/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.RequestHandle;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.SlingBean;
import com.composum.sling.core.request.DomIdentifiers;
import com.composum.sling.core.util.LinkUtil;
import java.lang.reflect.Constructor;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSlingBean
implements SlingBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSlingBean.class);
    protected BeanContext context;
    protected ResourceHandle resource;
    protected transient SlingScriptHelper sling;
    protected transient ResourceResolver resolver;
    protected transient Session session;
    protected transient QueryManager queryManager;
    protected transient RequestHandle request;
    protected transient SlingHttpServletResponse response;
    private transient String name;
    private transient String path;
    private transient String type;
    private transient String domId;
    private transient String id;
    private transient String url;
    private transient String title;
    private transient Node node;

    public AbstractSlingBean(BeanContext context, Resource resource) {
        this.initialize(context, resource);
    }

    public AbstractSlingBean(BeanContext context) {
        this.initialize(context);
    }

    public AbstractSlingBean() {
    }

    @Override
    public void initialize(BeanContext context) {
        this.initialize(context, context.getResource());
    }

    @Override
    public void initialize(BeanContext context, Resource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("initialize (" + context + ", " + resource + ")");
        }
        this.context = context;
        this.resource = ResourceHandle.use(resource);
    }

    public SlingScriptHelper getSling() {
        if (this.sling == null) {
            this.sling = this.context.getAttribute("sling", SlingScriptHelper.class);
        }
        return this.sling;
    }

    public ResourceResolver getResolver() {
        if (this.resolver == null) {
            this.resolver = this.getResource().getResourceResolver();
        }
        return this.resolver;
    }

    public ResourceHandle getResource() {
        return this.resource;
    }

    public String getUrl() {
        if (this.url == null) {
            RequestHandle request = this.getRequest();
            this.url = LinkUtil.getUrl((SlingHttpServletRequest)request, this.getPath(), request.getSelectors(), null);
        }
        return this.url;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = this.getResource().getPath();
        }
        return this.path;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getResource().getName();
        }
        return this.name;
    }

    @Override
    public String getType() {
        if (this.type == null) {
            this.type = this.getResource().getResourceType();
        }
        return this.type;
    }

    public String getDomId() {
        if (this.domId == null) {
            this.domId = DomIdentifiers.getInstance(this.context).getElementId(this);
        }
        return this.domId;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.getResource().getId();
        }
        return this.id;
    }

    public Node getNode() {
        if (this.node == null) {
            this.node = this.getResource().getNode();
            if (this.node == null) {
                this.node = this.context.getAttribute("currentNode", Node.class);
            }
        }
        return this.node;
    }

    public ResourceHandle getParent(String resourceType) {
        ResourceHandle result;
        for (result = this.getResource(); result != null && result.isValid() && !result.isResourceType(resourceType); result = result.getParent()) {
        }
        if (result != null && !result.isValid()) {
            result = this.getParent(resourceType, this.getPath());
        }
        return result;
    }

    public ResourceHandle getParent(String resourceType, String path) {
        int delimiter;
        Resource resource;
        ResourceResolver resolver = this.getResolver();
        while (((resource = resolver.getResource(path)) == null || !resource.isResourceType(resourceType)) && StringUtils.isNotBlank((CharSequence)path) && (delimiter = path.lastIndexOf(47)) >= 0) {
            path = path.substring(0, delimiter);
        }
        return ResourceHandle.use(resource);
    }

    public boolean getHasTitle() {
        return StringUtils.isNotBlank((CharSequence)this.getTitle());
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = this.getProperty("title", "");
            if (StringUtils.isBlank((CharSequence)this.title)) {
                this.title = this.getProperty("jcr:title", "");
            }
        }
        return this.title;
    }

    public ResourceHandle getContentResource() {
        return this.resource.getContentResource();
    }

    public <T> T getProperty(String key, T defaultValue) {
        return this.resource.getContentProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> type) {
        return (T)this.resource.getContentProperty(key, type);
    }

    public <T> T getInherited(String key, T defaultValue) {
        return this.resource.getInherited(key, defaultValue);
    }

    public <T> T getInherited(String key, Class<T> type) {
        return this.resource.getInherited(key, type);
    }

    public RequestHandle getRequest() {
        SlingHttpServletRequest req;
        if (this.request == null && (req = this.context.getRequest()) != null) {
            this.request = RequestHandle.use(req);
        }
        return this.request;
    }

    public SlingHttpServletResponse getResponse() {
        if (this.response == null) {
            this.response = this.context.getResponse();
        }
        return this.response;
    }

    public void executeQuery(String queryString, NodeClosure closure) throws RepositoryException {
        NodeIterator iterator = this.findNodes(queryString);
        while (iterator.hasNext()) {
            closure.call(iterator.nextNode());
        }
    }

    public <T extends AbstractSlingBean> List<T> findBeans(String queryString, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        try {
            Constructor<T> constructor = type.getConstructor(BeanContext.class, Resource.class);
            NodeIterator iterator = this.findNodes(queryString);
            ResourceResolver resolver = this.getResolver();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                Resource resource = resolver.getResource(node.getPath());
                if (resource == null) continue;
                result.add(constructor.newInstance(this.context, resource));
            }
        }
        catch (Exception rex) {
            LOG.error(rex.getMessage(), (Throwable)rex);
        }
        return result;
    }

    public List<String> findPathList(String queryString) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        NodeIterator iterator = this.findNodes(queryString);
        while (iterator.hasNext()) {
            result.add(iterator.nextNode().getPath());
        }
        return result;
    }

    public NodeIterator findNodes(String queryString) throws RepositoryException {
        return this.findNodes(queryString, "xpath");
    }

    public NodeIterator findNodes(String queryString, String type) throws RepositoryException {
        Query query = this.getQueryManager().createQuery(queryString, type);
        QueryResult result = query.execute();
        return result.getNodes();
    }

    public QueryManager getQueryManager() throws RepositoryException {
        if (this.queryManager == null) {
            this.queryManager = this.getSession().getWorkspace().getQueryManager();
        }
        return this.queryManager;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = (Session)this.getResolver().adaptTo(Session.class);
        }
        return this.session;
    }

    public String getUsername() {
        Principal principal = this.getRequest().getUserPrincipal();
        return principal != null ? principal.getName() : "";
    }

    public void toString(StringBuilder builder) {
        String jvmId = this.getStringId();
        String id = this.getId();
        if (id.equals(jvmId)) {
            builder.append(jvmId);
        } else {
            jvmId = jvmId.substring(jvmId.indexOf(64) + 1);
            builder.append(this.getClass().getSimpleName());
            builder.append('(').append(id).append('/').append(jvmId).append(')');
        }
        builder.append(",resource:").append(this.resource);
    }

    public String getStringId() {
        return super.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public static interface NodeClosure {
        public void call(Node var1) throws RepositoryException;
    }
}

