/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.CoreConfiguration;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.JobControlServlet;
import com.composum.sling.core.servlet.SetupServlet;
import com.composum.sling.core.servlet.SystemServlet;
import com.composum.sling.core.servlet.TranslationServlet;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={CoreConfiguration.class}, property={"service.description=Composum Nodes Core Configuration Service: the configuration service for all servlets in the core bundle"}, immediate=true)
@Designate(ocd=Configuration.class)
public class CoreConfigImpl
implements CoreConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CoreConfigImpl.class);
    protected static final String DEFAULT_LOGOUTURL = "/system/sling/logout.html?logout=true&GLO=true";
    protected static final String DEFAULT_LOGGEDOUTURL = "/system/sling/form/login.html";
    protected static final String DEFAULT_LOGINURL = "/system/sling/form/login.html";
    private volatile Configuration config;
    private volatile Map<String, Boolean> enabledServlets;
    private volatile Dictionary properties;

    @Nonnull
    private Configuration getConfig() {
        return Objects.requireNonNull(this.config, "CoreConfigImpl is not active");
    }

    @Override
    public boolean isEnabled(AbstractServiceServlet servlet) {
        return this.enabledServlets != null && Boolean.TRUE.equals(this.enabledServlets.get(((Object)((Object)servlet)).getClass().getSimpleName()));
    }

    @Override
    public Resource getErrorpage(SlingHttpServletRequest request, int status) {
        Resource errorpage = null;
        try {
            RequestPathInfo pathInfo;
            ResourceResolver resolver = request.getResourceResolver();
            String errorpagesPath = StringUtils.removeEnd((String)this.getConfig().errorpages_path(), (String)"/");
            if (StringUtils.isNotBlank((CharSequence)errorpagesPath) && "html".equalsIgnoreCase((pathInfo = request.getRequestPathInfo()).getExtension())) {
                if (errorpagesPath.startsWith("/")) {
                    errorpage = resolver.getResource(errorpagesPath + "/" + status);
                } else {
                    int lastSlash;
                    String path = pathInfo.getResourcePath();
                    Resource resource = resolver.resolve((HttpServletRequest)request, path);
                    path = resource.getPath();
                    while ((resource = resolver.getResource(path)) == null && (lastSlash = path.lastIndexOf(47)) > 2) {
                        path = path.substring(0, lastSlash);
                    }
                    while (errorpage == null && resource != null && !"/".equals(path = resource.getPath())) {
                        errorpage = resolver.getResource(path + "/" + errorpagesPath + "/" + status);
                        if (errorpage != null) continue;
                        resource = resource.getParent();
                    }
                }
            }
            String defaultErrorpages = StringUtils.removeEnd((String)this.getConfig().errorpages_default(), (String)"/");
            if (errorpage == null && StringUtils.isNotBlank((CharSequence)defaultErrorpages)) {
                errorpage = resolver.getResource(defaultErrorpages + "/" + status);
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return errorpage;
    }

    @Override
    public boolean forwardToErrorpage(SlingHttpServletRequest request, SlingHttpServletResponse response, int status) throws ServletException, IOException {
        Resource errorpage = this.getErrorpage(request, status);
        if (errorpage != null) {
            request.setAttribute("errorpage.status", (Object)status);
            RequestDispatcher dispatcher = request.getRequestDispatcher(errorpage);
            if (dispatcher != null) {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return true;
            }
        }
        return false;
    }

    public Dictionary getProperties() {
        return this.properties;
    }

    @Override
    public String getLoginUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getConfig().loginurl(), (CharSequence)"/system/sling/form/login.html");
    }

    @Override
    public String getLogoutUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getConfig().logouturl(), (CharSequence)DEFAULT_LOGOUTURL);
    }

    @Override
    public String getLoggedoutUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getConfig().loggedouturl(), (CharSequence)"/system/sling/form/login.html");
    }

    @Activate
    @Modified
    protected void activate(ComponentContext context, Configuration configuration) {
        this.properties = context.getProperties();
        this.config = configuration;
        HashMap<String, Boolean> theEnabledServlets = new HashMap<String, Boolean>();
        theEnabledServlets.put(SetupServlet.class.getSimpleName(), configuration.setup_servlet_enabled());
        theEnabledServlets.put(SystemServlet.class.getSimpleName(), configuration.system_servlet_enabled());
        theEnabledServlets.put(TranslationServlet.class.getSimpleName(), configuration.translation_servlet_enabled());
        theEnabledServlets.put(JobControlServlet.class.getSimpleName(), configuration.jobcontrol_servlet_enabled());
        this.enabledServlets = theEnabledServlets;
    }

    @Deactivate
    protected void deactivate() {
        this.properties = null;
    }

    @ObjectClassDefinition(name="Composum Nodes (Core) Configuration", description="the configuration service for all servlets in the core bundle")
    public static @interface Configuration {
        @AttributeDefinition(name="Errorpages", description="the path to the errorpages; e.g. 'meta/errorpages' for searching errorpages along the requested path")
        public String errorpages_path();

        @AttributeDefinition(name="Default Errorpages", description="the path to the systems default error pages")
        public String errorpages_default();

        @AttributeDefinition(name="Setup Servlet", description="the general on/off switch for the services of the Setup Servlet")
        public boolean setup_servlet_enabled() default true;

        @AttributeDefinition(name="Jobcontrol Servlet", description="the general on/off switch for the services of the Jobcontrol Servlet")
        public boolean jobcontrol_servlet_enabled() default true;

        @AttributeDefinition(name="System Servlet", description="the general on/off switch for the services of the System Servlet")
        public boolean system_servlet_enabled() default true;

        @AttributeDefinition(name="Translation Servlet", description="the general on/off switch for the services of the Translation Servlet")
        public boolean translation_servlet_enabled() default true;

        @AttributeDefinition(name="Logout URL", description="logout URL for the system")
        public String logouturl() default "/system/sling/logout.html?logout=true&GLO=true";

        @AttributeDefinition(name="Logged out URL", description="URL for the system to redirect to when the user was logged out")
        public String loggedouturl() default "/system/sling/form/login.html";

        @AttributeDefinition(name="Login URL", description="URL for the system to redirect / link to when the user should be logged in")
        public String loginurl() default "/system/sling/form/login.html";
    }
}

