/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.filter.StringFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;

public class RequestHandle
extends SlingHttpServletRequestWrapper {
    public static RequestHandle use(SlingHttpServletRequest request) {
        return request instanceof RequestHandle ? (RequestHandle)request : new RequestHandle(request);
    }

    protected RequestHandle(SlingHttpServletRequest request) {
        super(request);
    }

    public String getSelectors() {
        return this.getSelectors(StringFilter.ALL);
    }

    public String getSelectors(StringFilter filter) {
        return this.getSelectors(null, filter, null);
    }

    public String getSelectors(String[] prepend, StringFilter filter, String[] append) {
        String[] selectors = this.getSlingRequest().getRequestPathInfo().getSelectors();
        StringBuilder result = new StringBuilder();
        if (prepend != null && prepend.length > 0) {
            for (String s : prepend) {
                result.append('.');
                result.append(s);
            }
        }
        if (selectors != null && selectors.length > 0) {
            for (String selector : selectors) {
                if (!filter.accept(selector)) continue;
                result.append('.');
                result.append(selector);
            }
        }
        if (append != null && append.length > 0) {
            for (String s : append) {
                result.append('.');
                result.append(s);
            }
        }
        return result.toString();
    }

    public String getExtension() {
        String extension = this.getSlingRequest().getRequestPathInfo().getExtension();
        return StringUtils.isBlank((CharSequence)extension) ? "" : "." + extension;
    }
}

