/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core;

import com.composum.sling.core.InheritedValues;
import com.composum.sling.core.JcrResource;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.util.PropertyUtil;
import com.composum.sling.core.util.ResourceUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;

public class ResourceHandle
extends ResourceWrapper
implements JcrResource,
Cloneable {
    protected final Resource resource;
    @Nonnull
    protected final ValueMap properties;
    private transient Boolean valid;
    private transient Node node;
    private transient String path;
    private transient String id;
    private transient String title;
    private transient ResourceHandle contentResource;
    private transient Map<InheritedValues.Type, InheritedValues> inheritedValuesMap;
    protected InheritedValues.Type inheritanceType = InheritedValues.Type.contentRelated;
    protected boolean useNodeInheritance = false;
    protected transient Calendar lastModified;

    @Nonnull
    public static ResourceHandle use(@Nullable Resource resource) {
        return resource instanceof ResourceHandle ? (ResourceHandle)resource : new ResourceHandle(resource);
    }

    public static boolean isValid(@Nullable Resource resource) {
        return resource instanceof ResourceHandle ? ((ResourceHandle)resource).isValid() : resource != null && resource.getResourceResolver().getResource(resource.getPath()) != null;
    }

    protected ResourceHandle(Resource resource) {
        super(resource);
        this.resource = super.getResource();
        this.properties = ResourceUtil.getValueMap((Resource)this.resource);
    }

    public ResourceHandle clone() {
        try {
            return (ResourceHandle)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Bug: clone should work.", e);
        }
    }

    public boolean isValid() {
        if (this.valid == null) {
            this.valid = this.resource != null;
            if (this.valid.booleanValue()) {
                this.valid = this.getResourceResolver().getResource(this.getPath()) != null;
            }
        }
        return this.valid;
    }

    public <T> T getProperty(String key, T defaultValue) {
        Class<T> type = PropertyUtil.getType(defaultValue);
        T value = this.getProperty(key, type);
        return value != null ? value : defaultValue;
    }

    public <T> T getProperty(String key, Class<T> type) {
        return (T)this.properties.get(key, type);
    }

    public String getProperty(String key) {
        return this.getProperty(key, String.class);
    }

    @Nonnull
    public ValueMap getProperties() {
        return this.properties;
    }

    public void setProperty(String name, String value) throws RepositoryException {
        this.setProperty(name, value, 1);
    }

    public void setProperty(String name, boolean value) throws RepositoryException {
        this.setProperty(name, value, 6);
    }

    public void setProperty(String name, Calendar value) throws RepositoryException {
        this.setProperty(name, value, 5);
    }

    public void setProperty(String name, Object value, int type) throws RepositoryException {
        Node node = this.getNode();
        if (node != null) {
            PropertyUtil.setProperty(node, name, value, type);
        }
    }

    public void setProperty(String name, InputStream input) throws RepositoryException {
        Node node = this.getNode();
        if (node != null) {
            PropertyUtil.setProperty(node, name, input);
        }
    }

    public void setProperty(String name, Iterable<String> values) throws RepositoryException {
        this.setProperty(name, values, 1);
    }

    public void setProperty(String name, Iterable<?> values, int type) throws RepositoryException {
        Node node = this.getNode();
        if (node != null) {
            PropertyUtil.setProperty(node, name, values, type);
        }
    }

    public ResourceHandle getContentResource() {
        if (this.contentResource == null) {
            if ("jcr:content".equals(this.getName()) || !this.isValid()) {
                this.contentResource = this;
            } else {
                this.contentResource = ResourceHandle.use(this.getChild("jcr:content"));
                if (!this.contentResource.isValid()) {
                    this.contentResource = this;
                }
            }
        }
        return this.contentResource;
    }

    public <T> T getContentProperty(String key, Class<T> type) {
        return this.getContentResource().getProperty(key, type);
    }

    public <T> T getContentProperty(String key, T defaultValue) {
        return this.getContentResource().getProperty(key, defaultValue);
    }

    @Deprecated
    public void setUseNodeInheritance(boolean nodeInheritance) {
        this.setInheritanceType(InheritedValues.Type.sameContent);
    }

    @Deprecated
    public void setInheritanceType(InheritedValues.Type type) {
        this.inheritanceType = type;
    }

    public ResourceHandle withInheritanceType(InheritedValues.Type type) {
        Validate.notNull((Object)((Object)type), (String)"The inheritance type must not be null", (Object[])new Object[0]);
        if (this.inheritanceType == type) {
            return this;
        }
        ResourceHandle clone = this.clone();
        clone.setInheritanceType(type);
        return clone;
    }

    public InheritedValues getInheritedValues() {
        return this.getInheritedValues(this.inheritanceType);
    }

    public InheritedValues getInheritedValues(InheritedValues.Type type) {
        InheritedValues res;
        if (null == this.inheritedValuesMap) {
            this.inheritedValuesMap = new EnumMap<InheritedValues.Type, InheritedValues>(InheritedValues.Type.class);
        }
        if (null == (res = this.inheritedValuesMap.get((Object)type))) {
            res = new InheritedValues((Resource)this, type);
            this.inheritedValuesMap.put(type, res);
        }
        return res;
    }

    public <T> T getInherited(String key, T defaultValue) {
        return this.getInherited(key, defaultValue, this.inheritanceType);
    }

    public <T> T getInherited(String key, Class<T> type) {
        return this.getInherited(key, type, this.inheritanceType);
    }

    public <T> T getInherited(String key, T defaultValue, InheritedValues.Type inheritanceType) {
        Class<T> type = PropertyUtil.getType(defaultValue);
        T value = this.getInherited(key, type, inheritanceType);
        return value != null ? value : defaultValue;
    }

    public <T> T getInherited(String key, Class<T> type, InheritedValues.Type inheritanceType) {
        Object value = this.getProperty(key, type);
        if (value == null) {
            value = this.getInheritedValues(inheritanceType).get(key, type);
        }
        return value;
    }

    public Node getNode() {
        if (this.node == null && this.resource != null) {
            this.node = (Node)this.resource.adaptTo(Node.class);
        }
        return this.node;
    }

    @Override
    public String getPrimaryType() {
        return this.resource instanceof JcrResource ? ((JcrResource)this.resource).getPrimaryType() : this.getProperty("jcr:primaryType");
    }

    public boolean isOfType(String type) {
        return ResourceUtil.isResourceType(this.getResource(), type);
    }

    public String getId() {
        if (this.id == null) {
            if (this.isValid()) {
                this.id = this.getProperty("jcr:uuid");
            }
            if (StringUtils.isBlank((CharSequence)this.id)) {
                this.id = Base64.encodeBase64String((byte[])this.getPath().getBytes(MappingRules.CHARSET));
            }
        }
        return this.id;
    }

    public String getStringId() {
        return super.toString();
    }

    public String getName() {
        return this.resource != null ? super.getName() : null;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = this.getProperty("jcr:title", String.class);
            if (StringUtils.isBlank((CharSequence)this.title)) {
                this.title = this.getProperty("title", String.class);
            }
            if (StringUtils.isBlank((CharSequence)this.title)) {
                this.title = this.getName();
            }
        }
        return this.title;
    }

    public String getPath() {
        if (this.path == null && this.resource != null) {
            this.path = super.getPath();
            if (this.path.startsWith("//")) {
                this.path = this.path.substring(1);
            }
        }
        return this.path;
    }

    public boolean isResourceType(String resourceType) {
        return this.resource != null && super.isResourceType(resourceType);
    }

    public String getResourceType() {
        return this.resource != null ? super.getResourceType() : null;
    }

    public String getResourceName() {
        String name = this.getName();
        return StringUtils.isNotBlank((CharSequence)name) ? name : this.getPath();
    }

    public String getResourceTitle() {
        String title = this.getTitle();
        return StringUtils.isNotBlank((CharSequence)title) ? title : this.getResourceName();
    }

    @Nullable
    public ResourceHandle getParent() {
        if (this.resource != null) {
            Resource parent = super.getParent();
            if (parent == null && this.isSynthetic()) {
                String parentPath = this.getParentPath();
                if (StringUtils.isBlank((CharSequence)parentPath)) {
                    return null;
                }
                return ResourceHandle.use(this.getResourceResolver().resolve(parentPath));
            }
            if (parent == null) {
                return null;
            }
            return ResourceHandle.use(parent);
        }
        return null;
    }

    @Nullable
    public ResourceHandle getParent(int distance) {
        ResourceHandle parent;
        for (parent = this; distance > 0 && parent != null && parent.isValid(); parent = parent.getParent(), --distance) {
        }
        return parent;
    }

    public String getParentPath() {
        return ResourceUtil.getParent((String)this.getPath());
    }

    public ResourceHandle findUpwards(String basePath, Pattern namePattern, String childType) {
        for (ResourceHandle current = this; current != null && current.isValid(); current = current.getParent()) {
            ResourceHandle base = ResourceHandle.use(current.getChild(basePath));
            if (!base.isValid()) continue;
            for (ResourceHandle child : base.getChildrenByType(childType)) {
                if (!namePattern.matcher(child.getName()).matches()) continue;
                return child;
            }
        }
        return null;
    }

    public String toString() {
        return this.isValid() ? super.toString() : "<invalid: " + this.resource + ">";
    }

    public boolean isSynthetic() {
        return ResourceUtil.isSyntheticResource((Resource)this);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ResourceHandle.class) {
            return type.cast(this);
        }
        return (AdapterType)(this.resource != null ? super.adaptTo(type) : null);
    }

    public List<ResourceHandle> getChildrenByType(String type) {
        ArrayList<ResourceHandle> children = new ArrayList<ResourceHandle>();
        if (this.isValid()) {
            for (Resource child : this.resource.getChildren()) {
                ResourceHandle handle = ResourceHandle.use(child);
                if (!handle.isOfType(type)) continue;
                children.add(handle);
            }
        }
        return children;
    }

    public List<ResourceHandle> getChildrenByResourceType(String resourceType) {
        ArrayList<ResourceHandle> children = new ArrayList<ResourceHandle>();
        if (this.isValid()) {
            for (Resource child : this.resource.getChildren()) {
                ResourceHandle handle = ResourceHandle.use(child);
                if (!handle.isResourceType(resourceType)) continue;
                children.add(handle);
            }
        }
        return children;
    }

    public boolean isRenderable() {
        String resourceType = this.getResourceType();
        return !StringUtils.isBlank((CharSequence)resourceType) || this.isRenderableFile();
    }

    public boolean isRenderableFile() {
        return ResourceUtil.isRenderableFile(this);
    }

    public boolean isFile() {
        return ResourceUtil.isFile(this);
    }

    public Calendar getLastModified() {
        if (this.lastModified == null) {
            this.lastModified = this.getProperty("jcr:lastModified", Calendar.class);
            if (null == this.lastModified) {
                this.lastModified = this.getProperty("jcr:created", Calendar.class);
            }
        }
        return this.lastModified;
    }
}

