/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.config;

import com.composum.sling.core.config.FilterConfiguration;
import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.mapping.jcr.ResourceFilterMapping;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(name="ComposumFilterConfiguration", property={"service.description=Composum Nodes Filter Configuration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true)
@Designate(ocd=Configuration.class, factory=true)
public class FilterConfigurationImpl
implements FilterConfiguration {
    protected volatile String name;
    protected volatile ResourceFilter filter;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceFilter getFilter() {
        return this.filter;
    }

    @Activate
    @Modified
    protected void activate(Configuration configuration) {
        this.name = configuration.name();
        this.filter = ResourceFilterMapping.fromString(configuration.filter());
    }

    @Deactivate
    protected void deactivate() {
        this.name = null;
        this.filter = null;
    }

    @ObjectClassDefinition(name="Composum Filter Configuration", description="the configurable set of node filters for the node tree view")
    public static @interface Configuration {
        @AttributeDefinition(name="Name", description="name to identify and select the filter")
        public String name() default "";

        @AttributeDefinition(name="Filter", description="the resource filter definition rule")
        public String filter() default "";
    }
}

