/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public interface StringFilter {
    public static final StringFilter ALL = new All();

    public boolean accept(String var1);

    public boolean isRestriction();

    public void toString(StringBuilder var1);

    public static class FilterSet
    extends FilterBase {
        protected final Rule rule;
        protected final List<StringFilter> set;
        protected transient Boolean restriction;

        public FilterSet(Rule rule, StringFilter ... filters) {
            this.rule = rule;
            this.set = new ArrayList<StringFilter>();
            Collections.addAll(this.set, filters);
        }

        public FilterSet(Rule rule, List<StringFilter> filters) {
            this.rule = rule;
            this.set = filters;
        }

        public Rule getRule() {
            return this.rule;
        }

        public List<StringFilter> getSet() {
            return this.set;
        }

        @Override
        public boolean accept(String value) {
            switch (this.rule) {
                case or: {
                    for (StringFilter filter : this.set) {
                        if (!filter.accept(value)) continue;
                        return true;
                    }
                    return this.set.size() == 0;
                }
                case and: {
                    for (StringFilter filter : this.set) {
                        if (filter.accept(value)) continue;
                        return false;
                    }
                    return this.set.size() > 0;
                }
                case first: {
                    for (StringFilter filter : this.set) {
                        if (filter.accept(value) && !filter.isRestriction()) {
                            return true;
                        }
                        if (filter.accept(value) || !filter.isRestriction()) continue;
                        return false;
                    }
                    return false;
                }
                case last: {
                    boolean result = false;
                    for (StringFilter filter : this.set) {
                        if (filter.accept(value) && !filter.isRestriction()) {
                            result = true;
                        }
                        if (filter.accept(value) || !filter.isRestriction()) continue;
                        result = false;
                    }
                    return result;
                }
            }
            return this.isRestriction();
        }

        @Override
        public boolean isRestriction() {
            if (this.restriction == null) {
                block0 : switch (this.rule) {
                    case or: 
                    case last: {
                        this.restriction = true;
                        for (StringFilter filter : this.set) {
                            if (filter.isRestriction()) continue;
                            this.restriction = false;
                            break block0;
                        }
                        break;
                    }
                    case and: 
                    case first: {
                        this.restriction = false;
                        for (StringFilter filter : this.set) {
                            if (!filter.isRestriction()) continue;
                            this.restriction = true;
                            break block0;
                        }
                        break;
                    }
                }
            }
            return this.restriction;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append(this.rule.name());
            builder.append("{");
            int i = 0;
            while (i < this.set.size()) {
                this.set.get(i).toString(builder);
                if (++i >= this.set.size()) continue;
                builder.append(',');
            }
            builder.append("}");
        }

        public static enum Rule {
            and,
            or,
            first,
            last;

        }
    }

    public static class BlackList
    extends PatternList {
        public BlackList(String values) {
            super(values);
        }

        public BlackList(String ... values) {
            super(values);
        }

        public BlackList(Pattern[] patterns) {
            super(patterns);
        }

        public BlackList(List<Pattern> patterns) {
            super(patterns);
        }

        @Override
        public boolean accept(String value) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(value).find()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isRestriction() {
            return true;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("-'");
            super.toString(builder);
            builder.append("'");
        }
    }

    public static class WhiteList
    extends PatternList {
        public WhiteList(String values) {
            super(values);
        }

        public WhiteList(String ... values) {
            super(values);
        }

        public WhiteList(Pattern[] patterns) {
            super(patterns);
        }

        public WhiteList(List<Pattern> patterns) {
            super(patterns);
        }

        @Override
        public boolean accept(String value) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(value).find()) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isRestriction() {
            return false;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("+'");
            super.toString(builder);
            builder.append("'");
        }
    }

    public static abstract class PatternList
    extends FilterBase {
        protected List<Pattern> patterns;

        public PatternList(String values) {
            this(PatternList.patterns(StringUtils.split((String)values, (String)",")));
        }

        public PatternList(String[] values) {
            this(PatternList.patterns(values));
        }

        public PatternList(Pattern[] patterns) {
            this.patterns = Arrays.asList(patterns);
        }

        public PatternList(List<Pattern> patterns) {
            this.patterns = patterns;
        }

        public List<Pattern> getPatterns() {
            return this.patterns;
        }

        protected static List<Pattern> patterns(String[] values) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String value : values) {
                patterns.add(Pattern.compile(value));
            }
            return patterns;
        }

        protected static List<Pattern> patterns(List<String> values) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String value : values) {
                patterns.add(Pattern.compile(value));
            }
            return patterns;
        }

        @Override
        public void toString(StringBuilder builder) {
            int i = 0;
            while (i < this.patterns.size()) {
                builder.append(this.patterns.get(i).pattern());
                if (++i >= this.patterns.size()) continue;
                builder.append(',');
            }
        }
    }

    public static abstract class FilterBase
    implements StringFilter {
        public List<String> getFiltered(Iterable<String> values) {
            ArrayList<String> result = new ArrayList<String>();
            for (String value : values) {
                if (!this.accept(value)) continue;
                result.add(value);
            }
            return result;
        }

        public String[] getFiltered(String ... values) {
            ArrayList<String> result = new ArrayList<String>();
            for (String value : values) {
                if (!this.accept(value)) continue;
                result.add(value);
            }
            return result.toArray(new String[0]);
        }
    }

    public static class All
    implements StringFilter {
        @Override
        public boolean accept(String value) {
            return true;
        }

        @Override
        public boolean isRestriction() {
            return false;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append("All''");
        }
    }
}

