/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.logging;

import com.composum.sling.core.logging.Message;
import com.composum.sling.core.logging.MessageTypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAdapter(value=MessageTypeAdapterFactory.class)
@ThreadSafe
public class MessageContainer
implements Iterable<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(MessageContainer.class);
    protected static final Comparator<Message> MESSAGE_TIME_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(Message::getTimestamp));
    @Nullable
    protected volatile transient Logger log;
    protected final transient Object lockObject = new Object();
    @Nullable
    protected List<Message> messages;

    public MessageContainer() {
        this.log = null;
    }

    public MessageContainer(@Nullable Logger log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<Message> getMessages() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.messages != null ? Collections.unmodifiableList(new ArrayList<Message>(this.messages)) : Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public MessageContainer add(@Nullable Message message, @Nullable Throwable throwable) {
        if (message != null) {
            Object object = this.lockObject;
            synchronized (object) {
                if (this.messages == null) {
                    this.messages = new ArrayList<Message>();
                }
                boolean doSort = this.messages.size() > 0 && MESSAGE_TIME_COMPARATOR.compare(this.messages.get(this.messages.size() - 1), message) > 0;
                this.messages.add(message);
                if (doSort) {
                    this.messages.sort(MESSAGE_TIME_COMPARATOR);
                }
            }
            if (this.log != null) {
                message.logInto(this.log, throwable);
            } else if (throwable != null) {
                LOG.warn("Received throwable but have no logger: {}", (Object)message.toFormattedMessage(), (Object)throwable);
            }
        }
        return this;
    }

    @Nonnull
    public MessageContainer add(@Nullable Message message) {
        Object lastarg;
        Throwable throwable = null;
        List<Object> args = message.getArguments();
        if (args != null && !args.isEmpty() && (lastarg = args.get(args.size() - 1)) instanceof Throwable) {
            throwable = (Throwable)lastarg;
        }
        return this.add(message, throwable);
    }

    @Nonnull
    public MessageContainer addAll(@Nullable MessageContainer messageContainer) {
        if (messageContainer != null) {
            for (Message m : messageContainer) {
                this.add(m);
            }
        }
        return this;
    }

    public void logInto(@Nullable Logger logger) {
        if (logger == null) {
            return;
        }
        for (Message message : this.getMessages()) {
            message.logInto(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public MessageContainer clear() {
        Object object = this.lockObject;
        synchronized (object) {
            this.messages = null;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.messages == null || this.messages.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasError() {
        Object object = this.lockObject;
        synchronized (object) {
            if (null != this.messages) {
                return this.messages.stream().anyMatch(m -> m.getLevel().isError());
            }
            return false;
        }
    }

    @Override
    public Iterator<Message> iterator() {
        return this.getMessages().iterator();
    }

    @Override
    public void forEach(Consumer<? super Message> action) {
        this.getMessages().forEach(action);
    }

    @Override
    public Spliterator<Message> spliterator() {
        return this.getMessages().spliterator();
    }

    public void setLogger(Logger logger) {
        this.log = logger;
    }
}

