/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.logging;

import com.composum.sling.core.logging.Message;
import com.composum.sling.core.logging.MessageContainer;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTypeAdapterFactory
implements TypeAdapterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MessageTypeAdapterFactory.class);
    @Nonnull
    protected final Supplier<SlingHttpServletRequest> requestProvider;

    @Deprecated
    public MessageTypeAdapterFactory() {
        this(() -> null);
    }

    public MessageTypeAdapterFactory(@Nullable SlingHttpServletRequest request) {
        this.requestProvider = () -> request;
    }

    public MessageTypeAdapterFactory(@Nonnull Supplier<SlingHttpServletRequest> requestProvider) {
        this.requestProvider = Objects.requireNonNull(requestProvider);
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (MessageContainer.class.equals(type.getRawType())) {
            return new MessageContainerTypeAdapter(gson);
        }
        if (Message.class.isAssignableFrom(type.getRawType())) {
            TypeAdapter<T> defaultGsonAdapter = gson.getDelegateAdapter(this, type);
            return new MessageTypeAdapter(gson, Objects.requireNonNull(defaultGsonAdapter));
        }
        return null;
    }

    protected class MessageTypeAdapter
    extends TypeAdapter<Message> {
        @Nonnull
        protected final Gson gson;
        @Nonnull
        protected final TypeAdapter<Message> defaultGsonAdapter;

        public MessageTypeAdapter(@Nonnull Gson gson, TypeAdapter<Message> defaultGsonAdapter) {
            this.gson = gson;
            this.defaultGsonAdapter = defaultGsonAdapter;
        }

        @Override
        public void write(JsonWriter out, Message value) throws IOException {
            if (value != null) {
                Message i18nMessage = this.prepareI18nMessage(value);
                this.defaultGsonAdapter.write(out, i18nMessage);
            } else {
                out.nullValue();
            }
        }

        @Nonnull
        protected Message prepareI18nMessage(@Nonnull Message value) {
            Message i18nMessage = value;
            try {
                i18nMessage = value.prepareForJsonSerialization(MessageTypeAdapterFactory.this.requestProvider.get());
            }
            catch (CloneNotSupportedException impossible) {
                LOG.error("Could not clone " + value.getClass(), (Throwable)impossible);
                i18nMessage.getText();
            }
            return i18nMessage;
        }

        @Override
        public Message read(JsonReader in) throws IOException {
            return this.defaultGsonAdapter.read(in);
        }
    }

    protected static class MessageContainerTypeAdapter
    extends TypeAdapter<MessageContainer> {
        @Nonnull
        protected final Gson gson;

        public MessageContainerTypeAdapter(@Nonnull Gson gson) {
            this.gson = gson;
        }

        @Override
        public void write(JsonWriter out, MessageContainer container) throws IOException {
            if (container != null) {
                out.beginArray();
                for (Message msg : container.getMessages()) {
                    this.gson.toJson((Object)msg, msg.getClass(), out);
                }
                out.endArray();
            } else {
                out.nullValue();
            }
        }

        @Override
        public MessageContainer read(JsonReader in) throws IOException {
            MessageContainer container = new MessageContainer();
            in.beginArray();
            while (in.hasNext()) {
                container.add((Message)this.gson.fromJson(in, (Type)((Object)Message.class)));
            }
            in.endArray();
            return container;
        }
    }
}

