/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.security;

import com.composum.sling.core.AbstractSlingBean;
import com.composum.sling.core.BeanContext;
import com.composum.sling.core.RequestHandle;
import com.composum.sling.core.security.ConfigurationSet;
import com.composum.sling.core.util.RequestUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

public class SetupConfiguration
extends AbstractSlingBean {
    private transient Collection<String> categories;
    private transient List<ConfigBean> matchingSet;
    private transient ConfigurationSet configurationSet;

    public Collection<String> getCategories() {
        if (this.categories == null) {
            this.categories = this.getConfigurationSet().getScriptCategories().keySet();
        }
        return this.categories;
    }

    public List<ConfigBean> getMatchingSet() {
        if (this.matchingSet == null) {
            this.matchingSet = new ArrayList<ConfigBean>();
            String[] parameter = this.getRequest().getParameterValues("category");
            Collection<String> categories = parameter == null || parameter.length == 0 ? this.getCategories() : Arrays.asList(parameter);
            ConfigurationSet configurationSet = this.getConfigurationSet();
            for (ConfigurationSet.Configuration configuration : configurationSet.getConfigurations().values()) {
                ArrayList<ScriptBean> scripts = new ArrayList<ScriptBean>();
                for (ConfigurationSet.ConfigScript script : configuration.getScripts().values()) {
                    if (!configuration.matches(categories) && !script.matches(categories)) continue;
                    scripts.add(new ScriptBean(script));
                }
                if (scripts.size() <= 0) continue;
                Collections.sort(scripts);
                this.matchingSet.add(new ConfigBean(((ScriptBean)scripts.get(0)).getScript().getConfiguration(), scripts));
            }
            Collections.sort(this.matchingSet);
        }
        return this.matchingSet;
    }

    @Nonnull
    public ConfigurationSet getConfigurationSet() {
        if (this.configurationSet == null) {
            RequestHandle request = this.getRequest();
            if (RequestUtil.checkSelector((SlingHttpServletRequest)request, "refresh")) {
                ConfigurationSet.clear((SlingHttpServletRequest)request);
            }
            this.configurationSet = ConfigurationSet.instance((SlingHttpServletRequest)request);
        }
        return this.configurationSet;
    }

    public SetupConfiguration(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public SetupConfiguration(BeanContext context) {
        super(context);
    }

    public SetupConfiguration() {
    }

    public class ConfigBean
    extends AbstractSlingBean
    implements Comparable<ConfigBean> {
        private final ConfigurationSet.Configuration config;
        private final List<ScriptBean> scripts;

        public ConfigBean(ConfigurationSet.Configuration config, List<ScriptBean> scripts) {
            this.config = config;
            this.scripts = scripts;
            this.initialize(SetupConfiguration.this.context, SetupConfiguration.this.context.getResolver().getResource(config.getPath()));
        }

        @Nonnull
        public ConfigurationSet.Configuration getConfig() {
            return this.config;
        }

        @Nonnull
        public List<ScriptBean> getScripts() {
            return this.scripts;
        }

        @Override
        public int compareTo(@Nonnull ConfigBean other) {
            return this.config.compareTo(other.config);
        }
    }

    public class ScriptBean
    extends AbstractSlingBean
    implements Comparable<ScriptBean> {
        private final ConfigurationSet.ConfigScript script;

        public ScriptBean(ConfigurationSet.ConfigScript script) {
            this.script = script;
            this.initialize(SetupConfiguration.this.context, SetupConfiguration.this.context.getResolver().getResource(script.getPath()));
        }

        @Nonnull
        public String getScriptUrl() {
            return this.getRequest().getContextPath() + "/bin/browser.html" + this.getScript().getScriptPath();
        }

        @Nonnull
        public ConfigurationSet.ConfigScript getScript() {
            return this.script;
        }

        @Override
        public int compareTo(@Nonnull ScriptBean other) {
            return this.script.compareTo(other.script);
        }
    }
}

