/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.servlet;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.filter.ResourceFilter;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.MimeTypeUtil;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.core.util.XSS;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeTreeServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(NodeTreeServlet.class);

    protected abstract ResourceFilter getNodeFilter(SlingHttpServletRequest var1);

    protected List<Resource> prepareTreeItems(ResourceHandle resource, List<Resource> items) {
        return items;
    }

    public void writeJsonNode(JsonWriter writer, TreeNodeStrategy nodeStrategy, ResourceHandle resource, LabelType labelType, boolean isVirtual) throws IOException {
        writer.beginObject();
        this.writeJsonNodeData(writer, nodeStrategy, resource, labelType, isVirtual);
        writer.endObject();
    }

    public void writeJsonNodeData(JsonWriter writer, TreeNodeStrategy nodeStrategy, ResourceHandle resource, LabelType labelType, boolean isVirtual) throws IOException {
        ResourceFilter filter = nodeStrategy.getFilter();
        this.writeNodeIdentifiers(writer, nodeStrategy, resource, labelType, isVirtual);
        this.writeNodeTreeType(writer, filter, resource, isVirtual);
        this.writeNodeJcrState(writer, resource);
        List<Resource> children = new ArrayList<Resource>();
        boolean hasChildren = false;
        for (Resource child : nodeStrategy.getChildren(resource)) {
            hasChildren = true;
            if (!filter.accept(child) || ResourceUtil.containsPath(children, child) && ResourceUtil.isSyntheticResource((Resource)child)) continue;
            children.add(ResourceHandle.use(child));
        }
        if (!hasChildren) {
            if (!isVirtual) {
                this.addVirtualContent(writer, nodeStrategy, resource, labelType);
            }
        } else {
            children = this.prepareTreeItems(resource, children);
            writer.name("children").beginArray();
            for (Resource child : children) {
                ResourceHandle handle = ResourceHandle.use(child);
                writer.beginObject();
                this.writeNodeIdentifiers(writer, nodeStrategy, ResourceHandle.use(child), labelType, isVirtual);
                this.writeNodeTreeType(writer, filter, handle, isVirtual);
                this.writeNodeJcrState(writer, handle);
                writer.name("state").beginObject();
                writer.name("loaded").value(false);
                writer.endObject();
                writer.endObject();
            }
            writer.endArray();
        }
    }

    public void writeNodeTreeType(JsonWriter writer, ResourceFilter filter, ResourceHandle resource, boolean isVirtual) throws IOException {
        String treeType;
        String string = treeType = isVirtual ? "virtual" : "";
        if (StringUtils.isBlank((CharSequence)treeType) && filter instanceof ResourceFilter.FilterSet && ((ResourceFilter.FilterSet)filter).isIntermediate(resource)) {
            treeType = "intermediate";
        }
        if (StringUtils.isNotBlank((CharSequence)treeType)) {
            writer.name("treeType").value(treeType);
        }
    }

    public void addVirtualContent(JsonWriter writer, TreeNodeStrategy nodeStrategy, ResourceHandle resource, LabelType labelType) throws IOException {
        Node node = resource.adaptTo(Node.class);
        if (node != null) {
            try {
                Property property = node.getProperty("jcr:content");
                if (9 == property.getType()) {
                    Resource targetResource;
                    Node targetNode;
                    ResourceResolver resolver = resource.getResourceResolver();
                    String reference = property.getString();
                    Session session = node.getSession();
                    if (StringUtils.isNotBlank((CharSequence)reference) && (targetNode = session.getNodeByIdentifier(reference)) != null && (targetResource = resolver.getResource(targetNode.getPath() + "/" + "jcr:content")) != null) {
                        writer.name("children").beginArray();
                        this.writeJsonNode(writer, nodeStrategy, ResourceHandle.use(targetResource), labelType, true);
                        writer.endArray();
                    }
                }
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
    }

    public String getSortName(Resource resource) {
        String name = resource.getName().toLowerCase();
        name = name.startsWith("rep:") ? "a" + name : (name.startsWith("jcr:") ? "b" + name : "x" + name);
        return name;
    }

    public String getNodeLabel(ResourceHandle resource, LabelType labelType) {
        String text = resource.getName();
        if (labelType == LabelType.title) {
            ResourceHandle contentResource;
            String title = resource.getProperty("jcr:title", "");
            if (StringUtils.isBlank((CharSequence)title) && (contentResource = resource.getContentResource()) != null) {
                title = ResourceHandle.use(contentResource).getProperty("jcr:title", "");
            }
            if (StringUtils.isNotBlank((CharSequence)title)) {
                text = title;
            }
        }
        if (StringUtils.isBlank((CharSequence)text) && "/".equals(resource.getPath())) {
            text = "jcr:root";
        }
        return text;
    }

    public String writeNodeIdentifiers(JsonWriter writer, TreeNodeStrategy nodeStrategy, ResourceHandle resource, LabelType labelType, boolean isVirtual) throws IOException {
        String uuid;
        String text = this.getNodeLabel(resource, labelType);
        String type = nodeStrategy.getTypeKey(resource);
        String contentType = NodeTreeServlet.getContentTypeKey(nodeStrategy, resource, null);
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            writer.name("contentType").value(contentType);
            if ("designer".equals(contentType)) {
                type = type + "-" + contentType;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            writer.name("type").value(type);
        }
        String path = resource.getPath();
        writer.name("id").value(path + (isVirtual ? "-v" : ""));
        writer.name("name").value(resource.getName());
        writer.name("text").value(text);
        writer.name("path").value(path);
        String resourceType = resource.getResourceType();
        if (StringUtils.isNotBlank((CharSequence)resourceType)) {
            writer.name("resourceType").value(resourceType);
        }
        if (StringUtils.isNotBlank((CharSequence)(uuid = resource.getProperty("jcr:uuid")))) {
            writer.name("uuid").value(uuid);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNodeJcrState(JsonWriter writer, ResourceHandle resource) throws IOException {
        block8: {
            writer.name("jcrState").beginObject();
            try {
                Node node = resource.adaptTo(Node.class);
                if (node == null) break block8;
                try {
                    String nodePath = node.getPath();
                    Session session = node.getSession();
                    Workspace workspace = session.getWorkspace();
                    LockManager lockManager = workspace.getLockManager();
                    JsonUtil.writeValue(writer, "checkedOut", node.isCheckedOut());
                    JsonUtil.writeValue(writer, "isVersionable", this.isVersionable(node));
                    boolean isLocked = node.isLocked();
                    JsonUtil.writeValue(writer, "locked", isLocked);
                    if (!isLocked) break block8;
                    writer.name("lock").beginObject();
                    try {
                        Lock lock = lockManager.getLock(nodePath);
                        String holderPath = lock.getNode().getPath();
                        JsonUtil.writeValue(writer, "isDeep", lock.isDeep());
                        JsonUtil.writeValue(writer, "isHolder", holderPath.equals(nodePath));
                        JsonUtil.writeValue(writer, "node", holderPath);
                        JsonUtil.writeValue(writer, "owner", lock.getLockOwner());
                        JsonUtil.writeValue(writer, "sessionScoped", lock.isSessionScoped());
                    }
                    finally {
                        writer.endObject();
                    }
                }
                catch (RepositoryException rex) {
                    LOG.error(rex.getMessage(), (Throwable)rex);
                }
            }
            finally {
                writer.endObject();
            }
        }
    }

    private boolean isVersionable(Node node) throws RepositoryException {
        return node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable") || node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}simpleVersionable");
    }

    public NodeParameters getFormParameters(SlingHttpServletRequest request) {
        NodeParameters params = new NodeParameters();
        params.name = XSS.filter(request.getParameter("name"));
        params.path = XSS.filter(request.getParameter("path"));
        params.before = XSS.filter(request.getParameter("before"));
        params.index = XSS.filter(request.getParameter("index"));
        params.type = XSS.filter(request.getParameter("type"));
        params.title = XSS.filter(request.getParameter("title"));
        params.mimeType = XSS.filter(request.getParameter("mimeType"));
        params.resourceType = XSS.filter(request.getParameter("resourceType"));
        params.jcrContent = XSS.filter(request.getParameter("jcrContent"));
        return params;
    }

    public static String getContentTypeKey(TreeNodeStrategy strategy, ResourceHandle resource, String prefix) {
        String contentType = null;
        if (!"jcr:content".equals(resource.getName())) {
            resource = ResourceHandle.use(resource.getChild("jcr:content"));
        }
        if (resource.isValid()) {
            contentType = strategy.getContentTypeKey(resource, prefix);
        }
        return contentType;
    }

    public static String getPrimaryTypeKey(ResourceHandle resource) {
        String type = resource.getPrimaryType();
        if (StringUtils.isNotBlank((CharSequence)type)) {
            int namespace = type.lastIndexOf(58);
            if (namespace >= 0) {
                type = type.substring(namespace + 1);
            }
            type = type.toLowerCase();
        }
        return type;
    }

    public static String getResourceTypeKey(ResourceHandle resource, String prefix) {
        String resourceType;
        String primaryType = resource.getPrimaryType();
        String type = null;
        if (resource.isValid() && StringUtils.isNotBlank((CharSequence)(resourceType = resource.getResourceType())) && !resourceType.equals(primaryType)) {
            int dot;
            int namespace = resourceType.lastIndexOf(58);
            if (namespace >= 0) {
                resourceType = resourceType.substring(namespace + 1);
            }
            if ((dot = resourceType.lastIndexOf(46)) >= 0) {
                resourceType = resourceType.substring(dot + 1);
            }
            type = resourceType.substring(resourceType.lastIndexOf(47) + 1);
            type = type.toLowerCase();
        }
        if (StringUtils.isNotBlank(type) && StringUtils.isNotBlank((CharSequence)prefix)) {
            type = prefix + type;
        }
        return type;
    }

    public static String getFileTypeKey(ResourceHandle resource, String prefix) {
        String type = null;
        ResourceHandle content = ResourceHandle.use(resource.getChild("jcr:content"));
        if (content.isValid()) {
            type = NodeTreeServlet.getMimeTypeKey(content, prefix);
        }
        return type;
    }

    public static String getMimeTypeKey(ResourceHandle resource, String prefix) {
        String type = null;
        String mimeType = MimeTypeUtil.getMimeType(resource, "");
        if (StringUtils.isNotBlank((CharSequence)mimeType)) {
            int delim = mimeType.indexOf(47);
            String major = mimeType.substring(0, delim);
            String minor = mimeType.substring(delim + 1);
            type = major;
            if ("text".equals(major)) {
                type = type + "-" + minor;
            } else if ("application".equals(major)) {
                type = minor;
            }
            type = type.toLowerCase();
        }
        if (StringUtils.isNotBlank(type) && StringUtils.isNotBlank((CharSequence)prefix)) {
            type = prefix + type;
        }
        return type;
    }

    public static class NodeParameters {
        public String type;
        public String path;
        public String before;
        public String index;
        public String name;
        public String title;
        public String mimeType;
        public String resourceType;
        public String jcrContent;

        public Integer index() {
            return StringUtils.isNotBlank((CharSequence)this.index) ? Integer.valueOf(Integer.parseInt(this.index)) : null;
        }

        public Map<String, Object> asMap() {
            return new HashMap<String, Object>(){
                {
                    this.put("jcr:primaryType", type);
                    if (StringUtils.isNotBlank((CharSequence)mimeType)) {
                        this.put("jcr:mimeType", new String[]{mimeType});
                    }
                    if (StringUtils.isNotBlank((CharSequence)resourceType)) {
                        this.put("sling:resourceType", resourceType);
                    }
                    if (StringUtils.isNotBlank((CharSequence)title)) {
                        this.put("jcr:title", title);
                    }
                }
            };
        }
    }

    public class TreeOperation
    implements ServletOperation {
        protected TreeNodeStrategy getNodeStrategy(SlingHttpServletRequest request) {
            return new DefaultTreeNodeStrategy(this.getNodeFilter(request));
        }

        protected ResourceFilter getNodeFilter(SlingHttpServletRequest request) {
            return NodeTreeServlet.this.getNodeFilter(request);
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws ServletException, IOException {
            if (!(resource = AbstractServiceServlet.tryToUseRawSuffix(request, resource)).isValid()) {
                response.setStatus(404);
                return;
            }
            TreeNodeStrategy strategy = this.getNodeStrategy(request);
            LabelType labelType = RequestUtil.getParameter(request, "label", RequestUtil.getSelector(request, LabelType.name));
            JsonWriter jsonWriter = ResponseUtil.getJsonWriter(response);
            response.setStatus(200);
            NodeTreeServlet.this.writeJsonNode(jsonWriter, strategy, resource, labelType, false);
        }
    }

    public static class DefaultTreeNodeStrategy
    implements TreeNodeStrategy {
        protected final ResourceFilter filter;

        public DefaultTreeNodeStrategy(ResourceFilter filter) {
            this.filter = filter;
        }

        @Override
        public Iterable<Resource> getChildren(Resource nodeResource) {
            return nodeResource.getChildren();
        }

        @Override
        public ResourceFilter getFilter() {
            return this.filter;
        }

        @Override
        public String getTypeKey(ResourceHandle resource) {
            String type = NodeTreeServlet.getPrimaryTypeKey(resource);
            if ("file".equals(type)) {
                type = NodeTreeServlet.getFileTypeKey(resource, "file-");
            } else if ("resource".equals(type)) {
                type = NodeTreeServlet.getMimeTypeKey(resource, "resource-");
            } else if (StringUtils.isBlank((CharSequence)type) || "unstructured".equals(type)) {
                type = NodeTreeServlet.getResourceTypeKey(resource, "resource-");
            }
            return type;
        }

        @Override
        public String getContentTypeKey(ResourceHandle resource, String prefix) {
            return NodeTreeServlet.getResourceTypeKey(resource, prefix);
        }
    }

    public static interface TreeNodeStrategy {
        public Iterable<Resource> getChildren(Resource var1);

        public ResourceFilter getFilter();

        public String getTypeKey(ResourceHandle var1);

        public String getContentTypeKey(ResourceHandle var1, String var2);
    }

    public static enum LabelType {
        name,
        title;

    }
}

