/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionUtil.class);
    private final transient PageContext pageContext;
    private transient JspApplicationContext jspAppContext;
    private transient ExpressionFactory expressionFactory;
    private transient ELContext elContext;

    public ExpressionUtil(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    private JspApplicationContext getJspAppContext() {
        if (this.jspAppContext == null) {
            ServletContext servletContext = this.pageContext.getServletContext();
            this.jspAppContext = JspFactory.getDefaultFactory().getJspApplicationContext(servletContext);
        }
        return this.jspAppContext;
    }

    private ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            this.expressionFactory = this.getJspAppContext().getExpressionFactory();
        }
        return this.expressionFactory;
    }

    private ELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = this.pageContext.getELContext();
        }
        return this.elContext;
    }

    private ValueExpression createValueExpression(ELContext elContext, String expression, Class<?> type) {
        return this.getExpressionFactory().createValueExpression(elContext, expression, type);
    }

    public <T> T eval(Object value, T defaultValue) {
        String expression;
        Object result = null;
        if (value instanceof String && StringUtils.isNotBlank((CharSequence)(expression = (String)value))) {
            Class type;
            expression = expression.replaceAll("@\\{([^}]+)}", "\\${$1}");
            Class clazz = type = defaultValue != null ? defaultValue.getClass() : String.class;
            if (String.class.equals(type) && !expression.contains("${") && !expression.contains("#{")) {
                result = expression;
            } else {
                ELContext elContext = this.getELContext();
                ValueExpression valueExpression = this.createValueExpression(elContext, expression, type);
                result = valueExpression.getValue(elContext);
            }
        }
        return (T)(result != null ? result : (Object)defaultValue);
    }
}

