/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.util.LinkUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;

public interface LinkMapper {
    public static final String LINK_MAPPER_REQUEST_ATTRIBUTE = LinkMapper.class.getName() + "_linkMapper";
    public static final ContextMapper CONTEXT = new ContextMapper();
    public static final ResolverMapper RESOLVER = new ResolverMapper();

    public String mapUri(SlingHttpServletRequest var1, String var2);

    public static class ResolverMapper
    implements LinkMapper {
        @Override
        public String mapUri(SlingHttpServletRequest request, String uri) {
            ResourceResolver resolver = request.getResourceResolver();
            return LinkUtil.isExternalUrl(uri) ? uri : resolver.map((HttpServletRequest)request, uri);
        }
    }

    public static class ContextMapper
    implements LinkMapper {
        @Override
        public String mapUri(SlingHttpServletRequest request, String uri) {
            return LinkUtil.isExternalUrl(uri) ? uri : request.getContextPath() + LinkUtil.encodePath(uri);
        }
    }
}

