/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.util.XSS;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ResourceResolver;

public class RequestUtil
extends org.apache.sling.api.request.RequestUtil {
    public static Session getSession(SlingHttpServletRequest request) {
        ResourceResolver resolver = request.getResourceResolver();
        return (Session)resolver.adaptTo(Session.class);
    }

    public static <T extends Enum> T getExtension(SlingHttpServletRequest request, T defaultValue) {
        String extension = request.getRequestPathInfo().getExtension();
        if (extension != null) {
            Class<?> type = defaultValue.getClass();
            try {
                Object value = Enum.valueOf(type, extension.toLowerCase());
                return (T)value;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static <T extends Enum> T getSelector(SlingHttpServletRequest request, T defaultValue) {
        String[] selectors = request.getRequestPathInfo().getSelectors();
        Class<?> type = defaultValue.getClass();
        for (String selector : selectors) {
            try {
                Object value = Enum.valueOf(type, selector);
                return (T)value;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return defaultValue;
    }

    public static boolean checkSelector(SlingHttpServletRequest request, String key) {
        String[] selectors;
        for (String selector : selectors = request.getRequestPathInfo().getSelectors()) {
            if (!selector.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static int getIntSelector(SlingHttpServletRequest request, int defaultValue) {
        String[] selectors;
        for (String selector : selectors = request.getRequestPathInfo().getSelectors()) {
            try {
                return Integer.parseInt(selector);
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return defaultValue;
    }

    public static int getIntSelector(SlingHttpServletRequest request, Pattern groupPattern, int defaultValue) {
        String[] selectors;
        for (String selector : selectors = request.getRequestPathInfo().getSelectors()) {
            Matcher matcher = groupPattern.matcher(selector);
            if (!matcher.matches()) continue;
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String getParameter(RequestParameterMap parameters, String name, String defaultValue) {
        String string;
        RequestParameter parameter = parameters.getValue(name);
        return parameter != null && StringUtils.isNotBlank((CharSequence)(string = XSS.filter(parameter.getString()))) ? string : defaultValue;
    }

    public static String getParameter(SlingHttpServletRequest request, String name, String defaultValue) {
        String result = XSS.filter(request.getParameter(name));
        return StringUtils.isNotBlank((CharSequence)result) ? result : defaultValue;
    }

    public static Integer getParameter(RequestParameterMap parameters, String name, Integer defaultValue) {
        String string;
        Integer result = defaultValue;
        RequestParameter parameter = parameters.getValue(name);
        if (parameter != null && StringUtils.isNotBlank((CharSequence)(string = parameter.getString()))) {
            try {
                result = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Integer getParameter(SlingHttpServletRequest request, String name, Integer defaultValue) {
        Integer result = defaultValue;
        String string = request.getParameter(name);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                result = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Boolean getParameter(SlingHttpServletRequest request, String name, Boolean defaultValue) {
        Boolean result = null;
        String string = request.getParameter(name);
        if (string != null) {
            result = StringUtils.isBlank((CharSequence)string) || name.equals(string) || Boolean.parseBoolean(string);
        }
        return result != null ? result : defaultValue;
    }

    public static <T extends Enum> T getParameter(RequestParameterMap parameters, String name, T defaultValue) {
        String string;
        T result = null;
        RequestParameter parameter = parameters.getValue(name);
        if (parameter != null && StringUtils.isNotBlank((CharSequence)(string = parameter.getString()))) {
            try {
                result = (T)Enum.valueOf(defaultValue.getClass(), string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result != null ? result : (T)defaultValue;
    }

    public static <T extends Enum> T getParameter(SlingHttpServletRequest request, String name, T defaultValue) {
        T result = null;
        String string = request.getParameter(name);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                result = (T)Enum.valueOf(defaultValue.getClass(), string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result != null ? result : (T)defaultValue;
    }
}

