/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import com.composum.sling.core.util.ResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

public class SlingResourceUtil {
    public static String relativePath(@Nonnull String node, @Nonnull String other) {
        node = ResourceUtil.normalize((String)node);
        other = ResourceUtil.normalize((String)other);
        if (StringUtils.isBlank((CharSequence)node) || StringUtils.isBlank((CharSequence)other) || StringUtils.startsWith((CharSequence)node, (CharSequence)"/") && !StringUtils.startsWith((CharSequence)other, (CharSequence)"/") || !StringUtils.startsWith((CharSequence)node, (CharSequence)"/") && StringUtils.startsWith((CharSequence)other, (CharSequence)"/")) {
            throw new IllegalArgumentException("Invalid path: node=" + node + " , other=" + other);
        }
        if (node.equals(other)) {
            return "";
        }
        if (other.startsWith(node + '/')) {
            return other.substring(node.length() + 1);
        }
        if (!node.endsWith("/")) {
            node = node + "/";
        }
        if (other.startsWith(node)) {
            return other.substring(node.length());
        }
        String longestPrefix = StringUtils.getCommonPrefix((String[])new String[]{node, other});
        if (!longestPrefix.endsWith("/")) {
            longestPrefix = StringUtils.defaultString((String)ResourceUtil.getParent((String)longestPrefix));
        }
        String nodeRestpath = other.substring(longestPrefix.length());
        String otherRestpath = node.substring(longestPrefix.length());
        return StringUtils.repeat((String)"../", (int)StringUtils.countMatches((CharSequence)otherRestpath, (CharSequence)"/")) + nodeRestpath;
    }

    public static boolean isSameOrDescendant(@Nullable String parent, @Nullable String descendant) {
        String descendantNormalized;
        if (parent == null || descendant == null) {
            return false;
        }
        if (parent.equals(descendant) || parent.equals("/")) {
            return true;
        }
        if (descendant.startsWith(parent + '/') && !descendant.contains("..")) {
            return true;
        }
        String parentNormalized = ResourceUtil.normalize((String)parent);
        return parentNormalized.equals(descendantNormalized = ResourceUtil.normalize((String)descendant)) || parentNormalized.equals("/") || descendantNormalized.startsWith(parentNormalized + '/');
    }

    public static boolean isSameOrDescendant(@Nullable Resource parent, @Nullable Resource descendant) {
        if (parent == null || descendant == null) {
            return false;
        }
        return SlingResourceUtil.isSameOrDescendant(parent.getPath(), descendant.getPath());
    }

    @Nullable
    public static String getPath(@Nullable Resource resource) {
        return resource != null ? resource.getPath() : null;
    }

    @Nonnull
    public static List<String> getPaths(@Nullable List<Resource> resources) {
        ArrayList<String> paths = new ArrayList<String>();
        if (resources != null) {
            for (Resource resource : resources) {
                paths.add(SlingResourceUtil.getPath(resource));
            }
        }
        return paths;
    }

    public static boolean addMixin(@Nonnull Resource resource, @Nonnull String mixin) {
        if (!ResourceUtil.isResourceType(resource, mixin)) {
            ModifiableValueMap vm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            String[] mixins = (String[])vm.get("jcr:mixinTypes", (Object)new String[0]);
            ArrayList<String> newMixins = new ArrayList<String>(Arrays.asList(mixins));
            newMixins.add(mixin);
            vm.put((Object)"jcr:mixinTypes", (Object)newMixins.toArray(new String[0]));
            return true;
        }
        return false;
    }

    @Nonnull
    public static Iterable<Resource> descendants(@Nullable Resource resource) {
        return () -> SlingResourceUtil.descendantsStream(resource).iterator();
    }

    @Nonnull
    public static Stream<Resource> descendantsStream(@Nullable Resource resource) {
        return SlingResourceUtil.descendantsStream(resource, null);
    }

    @Nonnull
    public static Stream<Resource> descendantsStream(@Nullable Resource resource, @Nullable Function<Resource, Boolean> leafFilter) {
        if (resource == null) {
            return Stream.empty();
        }
        if (leafFilter != null && Boolean.TRUE.equals(leafFilter.apply(resource))) {
            return Stream.of(resource);
        }
        return Stream.concat(Stream.of(resource), StreamSupport.stream(resource.getChildren().spliterator(), false).flatMap(r -> SlingResourceUtil.descendantsStream(r, leafFilter)));
    }

    @Nonnull
    public static Stream<Resource> selfAndAncestors(@Nullable Resource r) {
        if (r == null) {
            return Stream.empty();
        }
        return Stream.iterate(r, Resource::getParent).limit(StringUtils.countMatches((CharSequence)r.getPath(), (CharSequence)"/")).filter(Objects::nonNull);
    }

    @Nullable
    public static String appendPaths(@Nullable String path, @Nullable String childpath) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)childpath)) {
            return path;
        }
        childpath = StringUtils.removeStart((String)childpath, (String)"/");
        if (StringUtils.isBlank((CharSequence)(childpath = StringUtils.removeEnd((String)childpath, (String)"/")))) {
            return path;
        }
        if ("/".equals(ResourceUtil.normalize((String)path))) {
            return "/" + childpath;
        }
        path = StringUtils.removeEnd((String)path, (String)"/");
        return path + "/" + childpath;
    }

    @Nullable
    public static String commonParent(@Nullable Collection<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return null;
        }
        String result = null;
        for (String path : paths) {
            if (StringUtils.isBlank((CharSequence)path)) continue;
            if (result == null) {
                result = path;
                continue;
            }
            while (!SlingResourceUtil.isSameOrDescendant(result, path) && result != null) {
                result = ResourceUtil.getParent((String)result);
            }
            if (result != null) continue;
            break;
        }
        return result;
    }

    @Nullable
    public static Resource getFirstExistingParent(@Nullable ResourceResolver resolver, @Nullable String path) {
        Resource result;
        if (resolver == null) {
            return null;
        }
        String searchedPath = path;
        Resource resource = result = StringUtils.isNotBlank((CharSequence)searchedPath) ? resolver.getResource(searchedPath) : null;
        while (result == null && StringUtils.isNotBlank((CharSequence)searchedPath)) {
            searchedPath = ResourceUtil.getParent((String)searchedPath);
            result = resolver.getResource(searchedPath);
        }
        return result;
    }

    public static void addMixin(@Nullable Resource resource, String ... mixins) {
        if (resource != null && mixins != null && mixins.length > 0) {
            ModifiableValueMap mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            String[] currentMixins = (String[])mvm.get("jcr:mixinTypes", String[].class);
            if (currentMixins == null) {
                mvm.put((Object)"jcr:mixinTypes", (Object)mixins);
            } else {
                ArrayList<String> allMixins = new ArrayList<String>();
                allMixins.addAll(Arrays.asList(currentMixins));
                for (String mixin : mixins) {
                    if (allMixins.contains(mixin)) continue;
                    allMixins.add(mixin);
                }
                mvm.put((Object)"jcr:mixinTypes", (Object)allMixins.toArray(new String[allMixins.size()]));
            }
        }
    }

    public static void setProperty(@Nonnull ModifiableValueMap valueMap, @Nonnull String key, @Nullable Object value) {
        if (value == null) {
            valueMap.remove((Object)key);
        } else {
            valueMap.put((Object)key, value);
        }
    }
}

