/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class StructuredValueMap
implements ValueMap {
    protected final ValueMap base;

    public StructuredValueMap(Map<String, Object> base) {
        this.base = base instanceof ValueMap ? (ValueMap)base : new ValueMapDecorator(base);
    }

    public <T> T get(@Nonnull String name, @Nonnull Class<T> type) {
        return (T)this._get(name, type);
    }

    @Nonnull
    public <T> T get(@Nonnull String name, @Nonnull T defaultValue) {
        Class<?> value = this.get(name, (T)defaultValue.getClass());
        return (T)(value == null ? defaultValue : value);
    }

    public int size() {
        return this._size((Map<String, Object>)this.base);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return key != null && this._containsKey(key.toString());
    }

    public boolean containsValue(Object value) {
        return value != null && this._containsValue(value);
    }

    public Object get(Object key) {
        return key != null ? this._get(key.toString(), null) : null;
    }

    @Nullable
    public Object put(String key, Object value) {
        return key != null ? this._put(key, value) : null;
    }

    public Object remove(Object key) {
        return key != null ? this._remove(key.toString()) : null;
    }

    public void putAll(@Nonnull Map<? extends String, ?> m) {
        for (String string : m.keySet()) {
            this.put(string, m.get(string));
        }
    }

    public void clear() {
        this.base.clear();
    }

    @Nonnull
    public Set<String> keySet() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this._keySet((Map<String, Object>)this.base, result, "");
        return result;
    }

    @Nonnull
    public Collection<Object> values() {
        ArrayList<Object> result = new ArrayList<Object>();
        this._values((Map<String, Object>)this.base, result);
        return result;
    }

    @Nonnull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.base.entrySet();
    }

    protected Object _get(@Nonnull String name, @Nullable Class<?> type) {
        return this._get(name.startsWith("/") ? name.substring(1) : name, type, (Map<String, Object>)this.base, name.contains("/") ? "/" : ".");
    }

    protected Object _get(@Nonnull String name, @Nullable Class<?> type, @Nonnull Map<String, Object> map, @Nonnull String delimiter) {
        Object nested;
        String[] path;
        Object value = this._get(map, name, type);
        if (value == null && (path = StringUtils.split((String)name, (String)delimiter, (int)2)).length > 1 && (nested = map.get(path[0])) instanceof Map) {
            value = this._get(path[1], type, (Map)nested, delimiter);
        }
        return value;
    }

    protected Object _get(@Nonnull Map<String, Object> map, @Nonnull String name, @Nullable Class<?> type) {
        Object value = type != null ? (map instanceof ValueMap ? ((ValueMap)map).get(name, type) : new ValueMapDecorator(map).get(name, type)) : map.get(name);
        return value;
    }

    protected Object _put(@Nonnull String name, @Nullable Object value) {
        return this._put(name.startsWith("/") ? name.substring(1) : name, value, (Map<String, Object>)this.base, name.contains("/") ? "/" : ".");
    }

    protected Object _put(@Nonnull String name, @Nullable Object value, @Nonnull Map<String, Object> map, @Nonnull String delimiter) {
        String[] path;
        if (!map.containsKey(name) && (path = StringUtils.split((String)name, (String)delimiter, (int)2)).length > 1) {
            Object nested = map.get(path[0]);
            if (nested == null) {
                nested = new ValueMapDecorator(new HashMap());
                map.put(path[0], nested);
            }
            if (nested instanceof Map) {
                return this._put(path[1], value, (Map)nested, delimiter);
            }
        }
        return map.put(name, value);
    }

    protected Object _remove(@Nonnull String name) {
        return this._remove(name.startsWith("/") ? name.substring(1) : name, (Map<String, Object>)this.base, name.contains("/") ? "/" : ".");
    }

    protected Object _remove(@Nonnull String name, @Nonnull Map<String, Object> map, @Nonnull String delimiter) {
        Object nested;
        String[] path;
        if (!map.containsKey(name) && (path = StringUtils.split((String)name, (String)delimiter, (int)2)).length > 1 && (nested = map.get(path[0])) instanceof Map) {
            return this._remove(path[1], (Map)nested, delimiter);
        }
        return map.remove(name);
    }

    protected void _keySet(Map<String, Object> map, Set<String> result, String prefix) {
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                this._keySet((Map)value, result, prefix + key + "/");
                continue;
            }
            result.add(prefix + key);
        }
    }

    protected void _values(Map<String, Object> map, Collection<Object> result) {
        for (Object value : map.values()) {
            if (value instanceof Map) {
                this._values((Map)value, result);
                continue;
            }
            result.add(value);
        }
    }

    protected int _size(Map<String, Object> map) {
        int size = map.size();
        for (Object value : map.values()) {
            if (!(value instanceof Map)) continue;
            size += this._size((Map)value) - 1;
        }
        return size;
    }

    protected boolean _containsKey(@Nonnull String name) {
        return this._containsKey(name.startsWith("/") ? name.substring(1) : name, (Map<String, Object>)this.base, name.contains("/") ? "/" : ".");
    }

    protected boolean _containsKey(@Nonnull String name, @Nonnull Map<String, Object> map, @Nonnull String delimiter) {
        Object nested;
        if (map.containsKey(name)) {
            return true;
        }
        String[] path = StringUtils.split((String)name, (String)delimiter, (int)2);
        if (path.length > 1 && (nested = map.get(path[0])) instanceof Map) {
            return this._containsKey(path[1], (Map)nested, delimiter);
        }
        return false;
    }

    protected boolean _containsValue(@Nonnull Object value) {
        return this._containsValue(value, (Map<String, Object>)this.base);
    }

    protected boolean _containsValue(@Nonnull Object value, @Nonnull Map<String, Object> map) {
        if (map.containsValue(value)) {
            return true;
        }
        for (Object val : map.values()) {
            if (!(val instanceof Map) || !this._containsValue(value, (Map)value)) continue;
            return true;
        }
        return false;
    }
}

