/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.util;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlCodec {
    private static final Logger LOG = LoggerFactory.getLogger(UrlCodec.class);
    protected static final String PART_URL_SAFECHARS = "-0-9a-zA-Z._+";
    public static final UrlCodec URLSAFE = new UrlCodec("-0-9a-zA-Z._+", StandardCharsets.UTF_8);
    public static final UrlCodec PATH = new UrlCodec("-0-9a-zA-Z._+/:@!$&'()*+,=", StandardCharsets.UTF_8);
    public static final UrlCodec AUTHORITY = new UrlCodec("-0-9a-zA-Z._+!$&'()*+,;=", StandardCharsets.UTF_8);
    public static final UrlCodec QUERYPART = new UrlCodec("-0-9a-zA-Z._+/:@!$'()*,;", StandardCharsets.UTF_8){

        @Override
        protected String charsToEncode(String admissibleCharacters) {
            return admissibleCharacters.replaceAll("\\+", " ");
        }

        @Override
        protected void encodePostprocess(StringBuffer out) {
            for (int i = 0; i < out.length(); ++i) {
                if (out.charAt(i) != ' ') continue;
                out.setCharAt(i, '+');
            }
        }

        @Override
        protected String decodePreprocess(String encoded) {
            return StringUtils.replaceChars((String)encoded, (char)'+', (char)' ');
        }
    };
    public static final UrlCodec FRAGMENT = new UrlCodec("-0-9a-zA-Z._+!$&'()*+,;=/?:@", StandardCharsets.UTF_8);
    public static final UrlCodec OPAQUE = new UrlCodec("-0-9a-zA-Z._+$.!*'(),;/?:@=&", StandardCharsets.UTF_8);
    protected static final Pattern PAT_ENCODED_CHARACTERS = Pattern.compile("(%[0-9a-fA-F][0-9a-fA-F])+");
    protected static final Pattern PAT_INVALID_ENCODED_CHARACTER = Pattern.compile("%(?![0-9a-fA-F][0-9a-fA-F]).{0,2}");
    protected static final String INVALID_CHARACTER_MARKER = "\ufffd";
    protected static final String HEXDIGITS = "0123456789ABCDEF";
    protected final Charset charset;
    protected final String admissibleCharacters;
    protected final Pattern charsToEncodeRegex;
    protected final Pattern validationRegex;
    protected transient String invalidCharacterMarkerForEncoding;

    public UrlCodec(@Nonnull String admissibleCharacters, @Nonnull Charset charset) throws IllegalArgumentException, PatternSyntaxException {
        this.charset = Objects.requireNonNull(charset);
        this.admissibleCharacters = Objects.requireNonNull(admissibleCharacters);
        this.charsToEncodeRegex = Pattern.compile("([^" + this.charsToEncode(admissibleCharacters) + "])+");
        if (!this.charsToEncodeRegex.matcher("%").matches()) {
            throw new IllegalArgumentException("Quoting character '%' cannot be admissible.");
        }
        this.validationRegex = Pattern.compile("([" + admissibleCharacters + "]|%[0-9a-fA-F][0-9a-fA-F])*");
    }

    protected String charsToEncode(String admissibleCharacters) {
        return admissibleCharacters;
    }

    @Nullable
    public String encode(@Nullable String encoded) {
        return this.encode(encoded, false);
    }

    @Nullable
    public String encodeValidated(@Nullable String encoded) throws IllegalArgumentException {
        return this.encode(encoded, true);
    }

    @Nullable
    public String decode(@Nullable String encoded) {
        return this.decode(encoded, false);
    }

    @Nullable
    protected String encode(@Nullable String encoded, boolean doThrow) {
        if (encoded == null || encoded.isEmpty()) {
            return encoded;
        }
        Matcher matcher = this.charsToEncodeRegex.matcher(encoded);
        ByteBuffer bytes = ByteBuffer.allocate(100);
        CharsetEncoder charsetEncoder = this.charset.newEncoder();
        StringBuffer out = new StringBuffer();
        while (matcher.find()) {
            CharBuffer matchBuffer;
            boolean overflow;
            matcher.appendReplacement(out, "");
            CharSequence match = encoded.subSequence(matcher.start(), matcher.end());
            boolean error = true;
            do {
                bytes.clear();
                charsetEncoder.reset();
                matchBuffer = CharBuffer.wrap(match);
                CoderResult result1 = charsetEncoder.encode(matchBuffer, bytes, true);
                CoderResult result2 = charsetEncoder.flush(bytes);
                overflow = result1.isOverflow() || result2.isOverflow();
                boolean bl = error = result1.isError() || result2.isError();
                if (!overflow) continue;
                bytes = ByteBuffer.allocate((int)Math.max((double)(2 * bytes.capacity()), (double)((float)match.length() * charsetEncoder.maxBytesPerChar()) * 1.2));
            } while (overflow);
            bytes.flip().rewind();
            this.writePercentEncoded(bytes, out);
            if (!error) continue;
            LOG.debug("Could not encode {} to {}", (Object)matcher.group(), (Object)this.charset.name());
            if (doThrow) {
                throw new IllegalArgumentException("Could not encode " + matcher.group());
            }
            out.append(StringUtils.repeat((String)this.getInvalidCharacterMarkerForEncoding(), (int)(matcher.end() - matcher.start() - matchBuffer.position())));
        }
        matcher.appendTail(out);
        this.encodePostprocess(out);
        return out.toString();
    }

    protected void encodePostprocess(StringBuffer out) {
    }

    protected void writePercentEncoded(ByteBuffer bytes, StringBuffer out) {
        while (bytes.hasRemaining()) {
            int b = bytes.get() + 256 & 0xFF;
            out.append('%').append(HEXDIGITS.charAt(b / 16)).append(HEXDIGITS.charAt(b % 16));
        }
    }

    protected String getInvalidCharacterMarkerForEncoding() {
        if (this.invalidCharacterMarkerForEncoding == null) {
            if (!this.charsToEncodeRegex.matcher(INVALID_CHARACTER_MARKER).matches()) {
                this.invalidCharacterMarkerForEncoding = INVALID_CHARACTER_MARKER;
            } else if (!this.charsToEncodeRegex.matcher("?").matches()) {
                this.invalidCharacterMarkerForEncoding = "?";
            } else {
                ByteBuffer byteBuffer = this.charset.encode(INVALID_CHARACTER_MARKER);
                StringBuffer buf = new StringBuffer();
                this.writePercentEncoded(byteBuffer, buf);
                this.invalidCharacterMarkerForEncoding = buf.toString();
            }
        }
        return this.invalidCharacterMarkerForEncoding;
    }

    @Nullable
    public String decodeValidated(@Nullable String encoded) throws IllegalArgumentException {
        return this.decode(encoded, true);
    }

    @Nullable
    protected String decode(@Nullable String encoded, boolean doThrow) throws IllegalArgumentException {
        Matcher fail;
        if ((encoded = this.decodePreprocess(encoded)) == null || encoded.isEmpty() || !encoded.contains("%")) {
            return encoded;
        }
        if (doThrow && (fail = PAT_INVALID_ENCODED_CHARACTER.matcher(encoded)).find()) {
            throw new IllegalArgumentException("Invalid encoded character " + fail.group());
        }
        Matcher m = PAT_ENCODED_CHARACTERS.matcher(encoded);
        CharBuffer out = CharBuffer.allocate(encoded.length() + 100);
        ByteBuffer bytes = ByteBuffer.allocate(100);
        CharsetDecoder charsetDecoder = this.charset.newDecoder();
        int appended = 0;
        try {
            while (m.find()) {
                out.append(encoded, appended, m.start());
                appended = m.end();
                if (bytes.capacity() < (m.end() - m.start()) / 3) {
                    bytes = ByteBuffer.allocate(m.end() - m.start());
                }
                bytes.clear();
                for (int i = m.start() + 1; i < m.end(); i += 3) {
                    bytes.put((byte)(16 * this.unhex(encoded.charAt(i)) + this.unhex(encoded.charAt(i + 1))));
                }
                charsetDecoder.reset();
                bytes.flip();
                CoderResult result = charsetDecoder.decode(bytes, out, true);
                this.checkResult(encoded, doThrow, out, result);
                result = charsetDecoder.flush(out);
                this.checkResult(encoded, doThrow, out, result);
            }
            out.append(encoded, appended, encoded.length());
        }
        catch (BufferOverflowException e) {
            LOG.error("Bug: Buffer overflow in decoding {}", (Object)encoded, (Object)e);
            if (doThrow) {
                throw e;
            }
            return out.flip().toString() + INVALID_CHARACTER_MARKER;
        }
        return out.flip().toString();
    }

    protected String decodePreprocess(String encoded) {
        return encoded;
    }

    protected void checkResult(@Nonnull String encoded, boolean doThrow, CharBuffer out, CoderResult result) throws IllegalArgumentException {
        if (result.isError()) {
            if (doThrow) {
                try {
                    result.throwException();
                }
                catch (CharacterCodingException e) {
                    throw new IllegalArgumentException(e);
                }
            } else {
                out.put(INVALID_CHARACTER_MARKER);
            }
        }
        if (result.isOverflow()) {
            LOG.error("Bug: overflow when decoding {}", (Object)encoded);
        }
    }

    protected byte unhex(char c) {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(10 + c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(10 + c - 65);
        }
        throw new IllegalArgumentException("Invalid hex char " + c);
    }

    public boolean isValid(@Nullable String encoded) {
        if (encoded == null || encoded.isEmpty()) {
            return true;
        }
        if (!this.validationRegex.matcher(encoded).matches()) {
            Matcher m;
            if (LOG.isDebugEnabled() && (m = this.validationRegex.matcher(encoded)).lookingAt()) {
                String invalidChars = StringUtils.abbreviate((String)encoded.substring(m.end()), (int)4);
                LOG.debug("Inadmissible character(s) at {} in input {}", (Object)invalidChars, (Object)encoded);
            }
            return false;
        }
        if (!encoded.contains("%")) {
            return true;
        }
        Matcher matcher = PAT_INVALID_ENCODED_CHARACTER.matcher(encoded);
        if (matcher.find()) {
            LOG.debug("Invalidly encoded character {} in input {}", (Object)matcher.group(), (Object)encoded);
            return false;
        }
        try {
            this.decode(encoded, true);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "UrlCodec{charset=" + this.charset + ", admissibleCharacters='" + this.admissibleCharacters + '\'' + '}';
    }
}

