/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.cpnl.CpnlBodyTagSupport;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.DynamicAttributes;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TagBase
extends CpnlBodyTagSupport
implements DynamicAttributes {
    public static final String TAG_NONE = "none";
    private static final Logger LOG = LoggerFactory.getLogger(TagBase.class);
    protected String tagName;
    protected String classes;
    protected Object test;
    private transient Boolean testResult;
    protected Map<String, Object> dynamicAttributes = new LinkedHashMap<String, Object>();

    @Override
    protected void clear() {
        super.clear();
        this.dynamicAttributes = new LinkedHashMap<String, Object>();
        this.testResult = null;
        this.test = null;
        this.classes = null;
        this.tagName = null;
    }

    protected abstract String getDefaultTagName();

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    protected String getTagName() {
        return StringUtils.isNotBlank((CharSequence)this.tagName) ? this.tagName : this.getDefaultTagName();
    }

    public String getClasses() {
        return StringUtils.isNotBlank((CharSequence)this.classes) ? this.classes : (String)this.dynamicAttributes.get("class");
    }

    public void setClasses(String classes) {
        this.classes = classes;
    }

    public void setTest(Object value) {
        this.test = value;
    }

    protected boolean getTestResult() {
        if (this.testResult == null) {
            this.testResult = this.eval(this.test, this.test instanceof Boolean ? (Boolean)this.test : Boolean.TRUE);
        }
        return this.testResult;
    }

    protected boolean acceptDynamicAttribute(String key, Object value) {
        return value != null;
    }

    public void setDynamicAttribute(String namespace, String name, Object value) {
        String key = name;
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            key = namespace + ":" + key;
        }
        if (this.acceptDynamicAttribute(key, value)) {
            this.dynamicAttributes.put(key, value);
        }
    }

    protected void writeAttributes(JspWriter writer) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)this.classes)) {
            writer.write(" class=\"");
            writer.write(this.classes);
            writer.write("\"");
        }
        for (Map.Entry<String, Object> entry : this.dynamicAttributes.entrySet()) {
            String string = entry.getValue().toString();
            writer.write(" ");
            writer.write(entry.getKey());
            writer.write("=\"");
            writer.write(this.eval(string, string));
            writer.write("\"");
        }
    }

    protected boolean renderTag() {
        return this.getTestResult();
    }

    @Override
    public int doStartTag() throws JspException {
        super.doStartTag();
        if (this.renderTag()) {
            this.renderTagStart();
            return 1;
        }
        return 0;
    }

    protected void renderTagStart() {
        String tagName = this.getTagName();
        if (!TAG_NONE.equalsIgnoreCase(tagName)) {
            try {
                JspWriter writer = this.pageContext.getOut();
                writer.write("<");
                writer.write(this.getTagName());
                this.writeAttributes(writer);
                writer.write(">");
            }
            catch (IOException ioex) {
                LOG.error(ioex.getMessage(), (Throwable)ioex);
            }
        }
    }

    public int doEndTag() throws JspException {
        if (this.renderTag()) {
            this.renderTagEnd();
        }
        super.doEndTag();
        return 6;
    }

    protected void renderTagEnd() {
        String tagName = this.getTagName();
        if (!TAG_NONE.equalsIgnoreCase(tagName)) {
            try {
                JspWriter writer = this.pageContext.getOut();
                writer.write("</");
                writer.write(this.getTagName());
                writer.write(">");
            }
            catch (IOException ioex) {
                LOG.error(ioex.getMessage(), (Throwable)ioex);
            }
        }
    }
}

