/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.core.util.I18N;
import com.composum.sling.cpnl.CpnlElFunctions;
import com.composum.sling.cpnl.TagBase;
import java.io.IOException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.scripting.jsp.util.TagUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextTag
extends TagBase {
    private static final Logger LOG = LoggerFactory.getLogger(TextTag.class);
    public static final Map<Type, EscapeFunction> ESCAPE_FUNCTION_MAP = new HashMap<Type, EscapeFunction>();
    protected Type type = Type.text;
    private Object value;
    private String propertyName;
    private boolean escape = true;
    private boolean i18n = false;
    private Format formatter;
    private String format;
    private Locale locale;
    private String output;

    @Override
    protected void clear() {
        this.type = Type.text;
        this.value = null;
        this.propertyName = null;
        this.locale = null;
        this.format = null;
        this.formatter = null;
        this.i18n = false;
        this.escape = true;
        this.output = null;
        super.clear();
    }

    @Override
    protected String getDefaultTagName() {
        return "div";
    }

    @Override
    public int doStartTag() throws JspException {
        int result = super.doStartTag();
        if (this.renderTag()) {
            this.bodyContent = null;
            this.output = null;
            if (this.value == null && this.propertyName != null) {
                Resource resource = TagUtil.getRequest((PageContext)this.pageContext).getResource();
                this.value = ResourceUtil.getValueMap((Resource)resource).get(this.propertyName, Object.class);
            }
            Format formatter = null;
            if (this.value != null) {
                formatter = this.getFormatter(this.value);
                if (formatter != null) {
                    Object object;
                    String stringValue;
                    String string = stringValue = this.value instanceof String ? (String)this.value : null;
                    if (StringUtils.isNotBlank((CharSequence)stringValue) && this.i18n) {
                        stringValue = I18N.get(this.request, stringValue);
                    }
                    if (formatter instanceof MessageFormat) {
                        String[] stringArray = new String[1];
                        object = stringArray;
                        stringArray[0] = stringValue != null ? stringValue : TextTag.toString(this.value);
                    } else {
                        object = this.value instanceof Calendar ? ((Calendar)this.value).getTime() : (stringValue != null ? stringValue : this.value);
                    }
                    this.output = formatter.format(object);
                } else {
                    this.output = TextTag.toString(this.value);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.output) && this.i18n && formatter == null) {
                this.output = I18N.get(this.request, this.output);
            }
            return this.output != null ? 0 : 2;
        }
        return result;
    }

    public int doAfterBody() {
        this.output = this.bodyContent.getString().trim();
        return 0;
    }

    @Override
    protected void renderTagStart() {
    }

    @Override
    protected void renderTagEnd() {
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.output)) {
                boolean renderTag;
                this.output = TextTag.toString(this.escape ? this.escape(this.output) : this.output);
                JspWriter writer = this.pageContext.getOut();
                boolean bl = renderTag = this.renderTag() && (StringUtils.isNotBlank((CharSequence)this.tagName) || StringUtils.isNotBlank((CharSequence)this.getClasses()));
                if (renderTag) {
                    super.renderTagStart();
                }
                writer.write(this.output);
                if (renderTag) {
                    super.renderTagEnd();
                }
            }
        }
        catch (IOException ioex) {
            LOG.error(ioex.getMessage(), (Throwable)ioex);
        }
    }

    public static String toString(Object value) {
        return value instanceof String ? (String)value : (value != null ? value.toString() : "");
    }

    protected Object escape(Object value) {
        EscapeFunction function = ESCAPE_FUNCTION_MAP.get((Object)this.type);
        return function != null ? function.escape(TagUtil.getRequest((PageContext)this.pageContext), value) : CpnlElFunctions.text(TextTag.toString(value));
    }

    public void setType(String type) {
        this.type = Type.valueOf(type);
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setI18n(boolean i18n) {
        this.i18n = i18n;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Format getFormatter(Object value) {
        if (this.formatter == null && this.format != null) {
            this.formatter = CpnlElFunctions.getFormatter(this.getLocale(), this.i18n ? I18N.get(this.request, this.format) : this.format, value != null ? value.getClass() : null);
        }
        return this.formatter;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.request.getLocale();
        }
        return this.locale;
    }

    public void setTagClass(String tagClass) {
        this.setClasses(tagClass);
    }

    static {
        ESCAPE_FUNCTION_MAP.put(Type.text, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.text(TextTag.toString(value));
            }
        });
        ESCAPE_FUNCTION_MAP.put(Type.rich, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.rich(request, TextTag.toString(value));
            }
        });
        ESCAPE_FUNCTION_MAP.put(Type.script, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.script(TextTag.toString(value));
            }
        });
        ESCAPE_FUNCTION_MAP.put(Type.style, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.style(TextTag.toString(value));
            }
        });
        ESCAPE_FUNCTION_MAP.put(Type.cdata, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.cdata(TextTag.toString(value));
            }
        });
        ESCAPE_FUNCTION_MAP.put(Type.path, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.path(TextTag.toString(value));
            }
        });
        ESCAPE_FUNCTION_MAP.put(Type.value, new EscapeFunction(){

            @Override
            public Object escape(SlingHttpServletRequest request, Object value) {
                return CpnlElFunctions.value(value);
            }
        });
    }

    public static interface EscapeFunction {
        public Object escape(SlingHttpServletRequest var1, Object var2);
    }

    public static enum Type {
        text,
        rich,
        script,
        style,
        cdata,
        path,
        value;

    }
}

