/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.cpnl;

import com.composum.sling.core.util.XSS;
import com.composum.sling.cpnl.CpnlElFunctions;
import com.composum.sling.cpnl.TagBase;
import java.io.IOException;
import java.text.Format;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UrlTag
extends TagBase {
    private static final Logger LOG = LoggerFactory.getLogger(UrlTag.class);
    private String urlAttr;
    private String url;
    private Boolean map;
    private String role;
    private String format;
    private Format formatter;

    @Override
    protected void clear() {
        super.clear();
        this.urlAttr = null;
        this.url = null;
        this.map = null;
        this.role = null;
        this.format = null;
        this.formatter = null;
    }

    protected abstract String getDefaultUrlAttr();

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUrlAttr(String urlAttr) {
        this.urlAttr = urlAttr;
    }

    protected String getUrlAttr() {
        return StringUtils.isNotBlank((CharSequence)this.urlAttr) ? this.urlAttr : this.getDefaultUrlAttr();
    }

    public void setMap(Boolean mapIt) {
        this.map = mapIt;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Format getFormatter(Object value) {
        if (this.formatter == null && this.format != null) {
            this.formatter = CpnlElFunctions.getFormatter(this.pageContext.getRequest().getLocale(), this.format, value != null ? value.getClass() : null);
        }
        return this.formatter;
    }

    @Nonnull
    protected String buildUrl(@Nonnull String urlValue, @Nullable Boolean map) {
        if (StringUtils.startsWith((CharSequence)urlValue, (CharSequence)"/") && !StringUtils.startsWith((CharSequence)urlValue, (CharSequence)"//")) {
            urlValue = map != null ? (map != false ? CpnlElFunctions.mappedUrl(this.request, urlValue) : CpnlElFunctions.unmappedUrl(this.request, urlValue)) : CpnlElFunctions.url(this.request, urlValue);
        }
        return XSS.getValidHref(urlValue);
    }

    @Override
    protected void writeAttributes(JspWriter writer) throws IOException {
        writer.write(" ");
        writer.write(this.getUrlAttr());
        writer.write("=\"");
        String urlValue = this.url;
        Format format = this.getFormatter(urlValue);
        if (format != null) {
            urlValue = format.format(urlValue);
        }
        urlValue = this.buildUrl(urlValue, this.map);
        writer.write(urlValue);
        writer.write("\"");
        if (StringUtils.isNotBlank((CharSequence)this.role)) {
            writer.write(" role=\"");
            writer.write(CpnlElFunctions.text(this.role));
            writer.write("\"");
        }
        super.writeAttributes(writer);
    }
}

