/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.control.handlers;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.CouchbaseMock;
import com.couchbase.mock.control.CommandStatus;
import com.couchbase.mock.control.MockCommand;
import com.couchbase.mock.memcached.MemcachedServer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class CCCPCommandHandler
extends MockCommand {
    @Override
    @NotNull
    public CommandStatus execute(@NotNull CouchbaseMock mock, @NotNull MockCommand.Command command, @NotNull JsonObject payload) {
        HashSet<String> enabledBuckets = new HashSet<String>();
        HashSet<Integer> enabledServers = new HashSet<Integer>();
        boolean enabled = payload.get("enabled").getAsBoolean();
        if (payload.has("bucket")) {
            enabledBuckets.add(payload.get("bucket").getAsString());
        } else {
            enabledBuckets.addAll(mock.getBuckets().keySet());
        }
        if (payload.has("servers")) {
            JsonArray arr = payload.get("servers").getAsJsonArray();
            for (int ii = 0; ii < arr.size(); ++ii) {
                JsonElement e = arr.get(ii);
                enabledServers.add(e.getAsInt());
            }
        }
        for (Bucket bucket : mock.getBuckets().values()) {
            if (!enabledBuckets.contains(bucket.getName())) continue;
            MemcachedServer[] servers = bucket.getServers();
            for (int ii = 0; ii < servers.length; ++ii) {
                if (!enabledServers.isEmpty() && !enabledServers.contains(ii)) continue;
                servers[ii].setCccpEnabled(enabled);
            }
        }
        return new CommandStatus();
    }
}

