/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.http.capi;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.JsonUtils;
import com.couchbase.mock.httpio.HandlerUtil;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.Storage;
import com.couchbase.mock.views.Configuration;
import com.couchbase.mock.views.QueryExecutionException;
import com.couchbase.mock.views.View;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;

public class ViewHandler
implements HttpRequestHandler {
    final View view;
    final Bucket bucket;

    public ViewHandler(View view, Bucket bucket) {
        this.view = view;
        this.bucket = bucket;
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String queryString;
        Iterable<Item> items = this.bucket.getMasterItems(Storage.StorageType.CACHE);
        URL url = HandlerUtil.getUrl(request);
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        if (request.getRequestLine().getMethod().equals("POST")) {
            HttpEntity reqEntity = ((HttpEntityEnclosingRequest)request).getEntity();
            String contentType = reqEntity.getContentType().getValue();
            String rawPayload = EntityUtils.toString(reqEntity);
            if (!contentType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
                HandlerUtil.makeJsonResponse(response, "Content type must be application/json");
                response.setStatusCode(400);
                return;
            }
            JsonObject jsonDecoded = JsonUtils.decode(rawPayload, JsonObject.class);
            for (Map.Entry<String, JsonElement> entry : jsonDecoded.entrySet()) {
                paramsMap.put(entry.getKey(), entry.getValue().toString());
            }
        }
        if ((queryString = url.getQuery()) != null && !queryString.isEmpty()) {
            try {
                Map<String, String> kvParams = HandlerUtil.getQueryParams(queryString);
                paramsMap.putAll(kvParams);
            }
            catch (MalformedURLException ex) {
                String errMessage = ex.getMessage();
                if (errMessage == null) {
                    errMessage = "Internal Error for " + queryString;
                }
                HandlerUtil.makeJsonResponse(response, errMessage);
                response.setStatusCode(400);
                return;
            }
        }
        try {
            String s = this.view.executeRaw(items, new Configuration(paramsMap));
            HandlerUtil.makeJsonResponse(response, s);
            response.setStatusCode(200);
            StringEntity entity = (StringEntity)response.getEntity();
            entity.setChunked(true);
        }
        catch (QueryExecutionException ex) {
            HandlerUtil.makeJsonResponse(response, ex.getJsonString());
            response.setStatusCode(400);
        }
    }
}

