/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.Bucket;
import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryHelloCommand;
import com.couchbase.mock.memcached.protocol.BinaryHelloResponse;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.ErrorCode;

public class HelloCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        if (server.getBucket().getType() != Bucket.BucketType.COUCHBASE) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.NOT_SUPPORTED));
            return;
        }
        BinaryHelloCommand hcmd = (BinaryHelloCommand)cmd;
        client.setSupportedFeatures(hcmd.getFeatures());
        boolean[] featuresSparse = client.getSupportedFeatures();
        int numFeatures = 0;
        for (boolean b : featuresSparse) {
            if (!b) continue;
            ++numFeatures;
        }
        int outIndex = 0;
        int[] featuresArray = new int[numFeatures];
        for (int i = 0; i < featuresSparse.length; ++i) {
            if (!featuresSparse[i]) continue;
            featuresArray[outIndex++] = i;
        }
        client.sendResponse(new BinaryHelloResponse(hcmd, featuresArray));
    }
}

