/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.Storage;
import com.couchbase.mock.memcached.VBucketCoordinates;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryObserveSeqnoCommand;
import com.couchbase.mock.memcached.protocol.BinaryObserveSeqnoResponse;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.ErrorCode;

public class ObserveSeqnoCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        Storage ss = server.getStorage();
        BinaryObserveSeqnoCommand ocmd = (BinaryObserveSeqnoCommand)cmd;
        VBucketStore cacheStore = ss.getCache(ocmd.getVBucketId());
        VBucketCoordinates coordRequest = cacheStore.findCoords(ocmd.getVBucketId(), ocmd.getUuid());
        VBucketCoordinates coordCurr = cacheStore.getCurrentCoords(ocmd.getVBucketId());
        if (coordRequest == null) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.EINTERNAL));
            return;
        }
        long seqnoDisk = ss.getPersistedSeqno(cmd.getVBucketId());
        long seqnoCache = coordRequest.getSeqno();
        if (coordRequest.getUuid() != coordCurr.getUuid()) {
            client.sendResponse(new BinaryObserveSeqnoResponse(ocmd, coordCurr, coordRequest, seqnoDisk));
        } else {
            client.sendResponse(new BinaryObserveSeqnoResponse(ocmd, seqnoCache, seqnoDisk));
        }
    }
}

