/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.MutationInfoWriter;
import com.couchbase.mock.memcached.MutationStatus;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.BinaryStoreCommand;
import com.couchbase.mock.memcached.protocol.BinaryStoreResponse;
import com.couchbase.mock.memcached.protocol.CommandCode;
import com.couchbase.mock.memcached.protocol.ErrorCode;

public class StoreCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        MutationStatus ms;
        BinaryStoreCommand command = (BinaryStoreCommand)cmd;
        VBucketStore cache = server.getStorage().getCache(server, cmd.getVBucketId());
        MutationInfoWriter miw = client.getMutinfoWriter();
        Item item = command.getItem();
        CommandCode cc = cmd.getComCode();
        switch (cc) {
            case ADD: 
            case ADDQ: {
                ms = cache.add(item);
                break;
            }
            case REPLACE: 
            case REPLACEQ: {
                ms = cache.replace(item);
                break;
            }
            case SET: 
            case SETQ: {
                ms = cache.set(item);
                break;
            }
            default: {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.EINTERNAL));
                return;
            }
        }
        if (ms.getStatus() == ErrorCode.SUCCESS && (cc == CommandCode.ADDQ || cc == CommandCode.SETQ || cc == CommandCode.REPLACEQ)) {
            return;
        }
        client.sendResponse(new BinaryStoreResponse(command, ms, miw, item.getCas()));
    }
}

