/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached;

import com.couchbase.mock.memcached.CommandExecutor;
import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.MemcachedConnection;
import com.couchbase.mock.memcached.MemcachedServer;
import com.couchbase.mock.memcached.MutationInfoWriter;
import com.couchbase.mock.memcached.MutationStatus;
import com.couchbase.mock.memcached.SubdocItem;
import com.couchbase.mock.memcached.VBucketStore;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.BinarySubdocCommand;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import com.couchbase.mock.subdoc.BadNumberException;
import com.couchbase.mock.subdoc.CannotInsertException;
import com.couchbase.mock.subdoc.DeltaTooBigException;
import com.couchbase.mock.subdoc.DocNotJsonException;
import com.couchbase.mock.subdoc.EmptyValueException;
import com.couchbase.mock.subdoc.Executor;
import com.couchbase.mock.subdoc.InvalidPathException;
import com.couchbase.mock.subdoc.NumberTooBigException;
import com.couchbase.mock.subdoc.Operation;
import com.couchbase.mock.subdoc.PathExistsException;
import com.couchbase.mock.subdoc.PathMismatchException;
import com.couchbase.mock.subdoc.PathNotFoundException;
import com.couchbase.mock.subdoc.PathParseException;
import com.couchbase.mock.subdoc.Result;
import com.couchbase.mock.subdoc.SubdocException;
import com.couchbase.mock.subdoc.ZeroDeltaException;

public class SubdocCommandExecutor
implements CommandExecutor {
    static ResultInfo executeSubdocOperation(Operation op, String doc, String path, String value, byte flags) {
        ErrorCode ec = ErrorCode.SUCCESS;
        Result result = null;
        boolean isMkdirP = (flags & 1) != 0;
        try {
            result = Executor.execute(doc, path, op, value, isMkdirP);
        }
        catch (PathNotFoundException ex2) {
            ec = ErrorCode.SUBDOC_PATH_ENOENT;
        }
        catch (PathExistsException ex3) {
            ec = ErrorCode.SUBDOC_PATH_EEXISTS;
        }
        catch (BadNumberException ex4_1) {
            ec = ErrorCode.SUBDOC_DELTA_ERANGE;
        }
        catch (EmptyValueException ex4) {
            ec = ErrorCode.SUBDOC_VALUE_CANTINSERT;
        }
        catch (DocNotJsonException ex5) {
            ec = ErrorCode.SUBDOC_DOC_NOTJSON;
        }
        catch (InvalidPathException ex6) {
            ec = ErrorCode.SUBDOC_PATH_EINVAL;
        }
        catch (NumberTooBigException ex7) {
            ec = ErrorCode.SUBDOC_NUM_ERANGE;
        }
        catch (DeltaTooBigException ex8) {
            ec = ErrorCode.SUBDOC_DELTA_ERANGE;
        }
        catch (CannotInsertException ex9) {
            ec = ErrorCode.SUBDOC_VALUE_CANTINSERT;
        }
        catch (PathParseException ex10) {
            ec = ErrorCode.SUBDOC_PATH_EINVAL;
        }
        catch (PathMismatchException ex11) {
            ec = ErrorCode.SUBDOC_PATH_MISMATCH;
        }
        catch (ZeroDeltaException ex12) {
            ec = ErrorCode.SUBDOC_DELTA_ERANGE;
        }
        catch (SubdocException exFallback) {
            throw new RuntimeException(exFallback);
        }
        return new ResultInfo(result, ec);
    }

    public static ResultInfo executeSubdocLookup(Operation op, String doc, String path) {
        return SubdocCommandExecutor.executeSubdocOperation(op, doc, path, null, (byte)0);
    }

    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        ResultInfo rci;
        byte[] curValue;
        BinarySubdocCommand command = (BinarySubdocCommand)cmd;
        Operation subdocOp = command.getSubdocOp();
        VBucketStore cache = server.getCache(cmd);
        SubdocItem subdocInput = command.getItem();
        boolean isMkdoc = (command.getSubdocDocFlags() & 3) != 0;
        boolean isXattr = (command.getSubdocPathFlags() & 4) != 0;
        boolean needsCreate = false;
        if (isMkdoc && !subdocOp.isCreative()) {
            client.sendResponse(new BinaryResponse(cmd, ErrorCode.EINVAL));
            return;
        }
        Item existing = cache.get(subdocInput.getKeySpec());
        if (existing == null) {
            byte[] newAttr;
            byte[] newBody;
            if (!isMkdoc) {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.KEY_ENOENT));
                return;
            }
            String newValue = Executor.getRootType(subdocInput.getPath(), subdocOp);
            if (newValue == null) {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.KEY_ENOENT));
                return;
            }
            if (isXattr) {
                newBody = null;
                newAttr = newValue.getBytes();
            } else {
                newAttr = null;
                newBody = newValue.getBytes();
            }
            existing = new Item(subdocInput.getKeySpec(), 0, 0, newBody, newAttr, 0L);
            needsCreate = true;
        } else if ((command.getSubdocDocFlags() & 2) != 0) {
            client.sendResponse(new BinaryResponse(command, ErrorCode.KEY_EEXISTS));
            return;
        }
        if (command.getCas() != 0L) {
            subdocInput.setCas(command.getCas());
        } else {
            subdocInput.setCas(existing.getCas());
        }
        if (isXattr) {
            curValue = existing.getXattr();
            if (curValue == null) {
                curValue = "{}".getBytes();
            }
        } else {
            curValue = existing.getValue();
            if (curValue == null) {
                curValue = "".getBytes();
            }
        }
        byte pathflags = command.getSubdocPathFlags();
        if (isMkdoc) {
            pathflags = (byte)(pathflags | 1);
        }
        if ((rci = SubdocCommandExecutor.executeSubdocOperation(subdocOp, new String(curValue), subdocInput.getPath(), new String(subdocInput.getValue()), pathflags)).getStatus() != ErrorCode.SUCCESS) {
            client.sendResponse(new BinaryResponse(cmd, rci.getStatus()));
            return;
        }
        byte[] value = null;
        if (subdocOp.returnsMatch()) {
            value = rci.getMatchString().getBytes();
        }
        if (subdocOp.isMutator()) {
            MutationStatus ms;
            byte[] body;
            byte[] xattr;
            MutationInfoWriter miw = client.getMutinfoWriter();
            if (isXattr) {
                xattr = rci.getNewDocString().getBytes();
                body = existing.getValue();
            } else {
                xattr = existing.getXattr();
                body = rci.getNewDocString().getBytes();
            }
            Item newItm = new Item(existing.getKeySpec(), existing.getFlags(), subdocInput.getExpiryTime(), body, xattr, subdocInput.getCas());
            if (needsCreate) {
                ms = cache.add(newItm);
                if (ms.getStatus() == ErrorCode.KEY_EEXISTS) {
                    this.execute(cmd, server, client);
                    return;
                }
            } else {
                ms = cache.replace(newItm);
            }
            if (ms.getStatus() == ErrorCode.SUCCESS) {
                client.sendResponse(new BinaryResponse(cmd, ms, miw, newItm.getCas(), value));
            } else {
                client.sendResponse(new BinaryResponse(cmd, ms.getStatus()));
            }
        } else {
            client.sendResponse(BinaryResponse.createWithValue(command, value, existing.getCas()));
        }
    }

    public static class ResultInfo {
        private final Result result;
        private final ErrorCode status;

        ResultInfo(Result result, ErrorCode status) {
            this.result = result;
            this.status = status;
        }

        public String getNewDocString() {
            return this.result.getNewDocString();
        }

        public String getMatchString() {
            return this.result.getMatchString();
        }

        public ErrorCode getStatus() {
            return this.status;
        }
    }
}

