/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.client;

import com.couchbase.mock.memcached.client.MemcachedClient;
import com.couchbase.mock.memcached.errormap.RetrySpec;

public class Retryer {
    final MemcachedClient client;
    final RetrySpec spec;
    final byte[] cmd;

    public Retryer(MemcachedClient client, RetrySpec spec, byte[] cmd) {
        this.client = client;
        this.spec = spec;
        this.cmd = cmd;
    }

    private static void accuSleep(long sleepTime) throws InterruptedException {
        long timeAfterSleep = System.currentTimeMillis() + sleepTime;
        while (System.currentTimeMillis() < timeAfterSleep) {
            Thread.sleep(0L, 500000);
        }
    }

    public void run() throws Exception {
        this.client.sendRequest(this.cmd);
        long endTime = System.currentTimeMillis() + (long)this.spec.getMaxDuration();
        Thread.sleep(this.spec.getAfter());
        int numAttempts = 0;
        long now = System.currentTimeMillis();
        while (now < endTime) {
            this.client.sendRequest(this.cmd);
            now = System.currentTimeMillis();
            ++numAttempts;
            long sleepTime = 0L;
            if (this.spec.isConstant()) {
                sleepTime = this.spec.getInterval();
            } else if (this.spec.isLinear()) {
                sleepTime = this.spec.getInterval() * numAttempts;
            } else if (this.spec.isExponential()) {
                sleepTime = (long)Math.pow(this.spec.getInterval(), numAttempts);
            }
            if (this.spec.getCeil() > 0) {
                sleepTime = Math.min((long)this.spec.getCeil(), sleepTime);
            }
            if (now + sleepTime > endTime) break;
            Retryer.accuSleep(sleepTime);
            now = System.currentTimeMillis();
        }
    }

    public void runError() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.client.sendRequest(this.cmd);
        }
    }
}

