/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.Item;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryGetCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.nio.ByteBuffer;

public class BinaryGetResponse
extends BinaryResponse {
    public BinaryGetResponse(BinaryCommand command, ErrorCode error) {
        super(command, error);
    }

    public BinaryGetResponse(BinaryCommand command, ErrorCode error, String errorContext) {
        super(command, error, errorContext);
    }

    public BinaryGetResponse(BinaryCommand command, Item item) {
        super(BinaryGetResponse.create(command, item));
    }

    public BinaryGetResponse(BinaryGetCommand cmd, Item item, long casOverride) {
        super(BinaryGetResponse.create(cmd, item, casOverride));
    }

    private static ByteBuffer create(BinaryCommand command, Item item) {
        return BinaryGetResponse.create(command, item, null);
    }

    private static ByteBuffer create(BinaryCommand command, Item item, Long casOverride) {
        int keySize;
        byte[] keyBytes;
        switch (command.getComCode()) {
            case GETK: 
            case GETKQ: 
            case GET_REPLICA: {
                keyBytes = command.getKey().getBytes();
                keySize = command.getKey().length();
                break;
            }
            case GET_RANDOM: {
                keyBytes = item.getKeySpec().key.getBytes();
                keySize = item.getKeySpec().key.length();
                break;
            }
            default: {
                keySize = 0;
                keyBytes = null;
            }
        }
        ByteBuffer message = BinaryGetResponse.create(command, ErrorCode.SUCCESS, 4, keySize, item.getValue().length, casOverride == null ? item.getCas() : casOverride.longValue());
        message.putInt(item.getFlags());
        if (keySize > 0) {
            message.put(keyBytes);
        }
        message.put(item.getValue());
        message.rewind();
        return message;
    }
}

