/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.mock.memcached.protocol;

import com.couchbase.mock.memcached.ObsKeyState;
import com.couchbase.mock.memcached.protocol.BinaryCommand;
import com.couchbase.mock.memcached.protocol.BinaryResponse;
import com.couchbase.mock.memcached.protocol.ErrorCode;
import java.nio.ByteBuffer;
import java.util.List;

public class BinaryObserveResponse
extends BinaryResponse {
    private static int calculateLength(List<ObsKeyState> states) {
        int len = 0;
        for (ObsKeyState ks : states) {
            len += 13;
            len += ks.key.length();
        }
        return len;
    }

    private static ByteBuffer create(BinaryCommand command, List<ObsKeyState> states) {
        int len = BinaryObserveResponse.calculateLength(states);
        ByteBuffer message = BinaryResponse.create(command, ErrorCode.SUCCESS, 0, 0, len, 0L);
        for (ObsKeyState ks : states) {
            message.putShort(ks.vbId);
            message.putShort((short)ks.key.length());
            message.put(ks.key.getBytes());
            message.put((byte)ks.status.getValue());
            message.putLong(ks.cas);
        }
        message.rewind();
        return message;
    }

    public BinaryObserveResponse(BinaryCommand command, List<ObsKeyState> states) {
        super(BinaryObserveResponse.create(command, states));
    }
}

