/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.ss.formula.ptg;

import shadeio.poi.ss.formula.SheetIdentifier;
import shadeio.poi.ss.formula.SheetRangeAndWorkbookIndexFormatter;
import shadeio.poi.ss.formula.SheetRangeIdentifier;
import shadeio.poi.ss.formula.ptg.Pxg3D;
import shadeio.poi.ss.formula.ptg.RefPtgBase;
import shadeio.poi.ss.util.CellReference;
import shadeio.poi.util.LittleEndianOutput;

public final class Ref3DPxg
extends RefPtgBase
implements Pxg3D {
    private int externalWorkbookNumber = -1;
    private String firstSheetName;
    private String lastSheetName;

    public Ref3DPxg(Ref3DPxg other) {
        super(other);
        this.externalWorkbookNumber = other.externalWorkbookNumber;
        this.firstSheetName = other.firstSheetName;
        this.lastSheetName = other.lastSheetName;
    }

    public Ref3DPxg(int externalWorkbookNumber, SheetIdentifier sheetName2, String cellref) {
        this(externalWorkbookNumber, sheetName2, new CellReference(cellref));
    }

    public Ref3DPxg(int externalWorkbookNumber, SheetIdentifier sheetName2, CellReference c) {
        super(c);
        this.externalWorkbookNumber = externalWorkbookNumber;
        this.firstSheetName = sheetName2.getSheetIdentifier().getName();
        this.lastSheetName = sheetName2 instanceof SheetRangeIdentifier ? ((SheetRangeIdentifier)sheetName2).getLastSheetIdentifier().getName() : null;
    }

    public Ref3DPxg(SheetIdentifier sheetName2, String cellref) {
        this(sheetName2, new CellReference(cellref));
    }

    public Ref3DPxg(SheetIdentifier sheetName2, CellReference c) {
        this(-1, sheetName2, c);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" [");
        if (this.externalWorkbookNumber >= 0) {
            sb.append(" [");
            sb.append("workbook=").append(this.getExternalWorkbookNumber());
            sb.append("] ");
        }
        sb.append("sheet=").append(this.firstSheetName);
        if (this.lastSheetName != null) {
            sb.append(" : ");
            sb.append("sheet=").append(this.lastSheetName);
        }
        sb.append(" ! ");
        sb.append(this.formatReferenceAsString());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public int getExternalWorkbookNumber() {
        return this.externalWorkbookNumber;
    }

    @Override
    public String getSheetName() {
        return this.firstSheetName;
    }

    @Override
    public String getLastSheetName() {
        return this.lastSheetName;
    }

    @Override
    public void setSheetName(String sheetName2) {
        this.firstSheetName = sheetName2;
    }

    @Override
    public void setLastSheetName(String sheetName2) {
        this.lastSheetName = sheetName2;
    }

    public String format2DRefAsString() {
        return this.formatReferenceAsString();
    }

    @Override
    public String toFormulaString() {
        StringBuilder sb = new StringBuilder(64);
        SheetRangeAndWorkbookIndexFormatter.format(sb, this.externalWorkbookNumber, this.firstSheetName, this.lastSheetName);
        sb.append('!');
        sb.append(this.formatReferenceAsString());
        return sb.toString();
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public void write(LittleEndianOutput out) {
        throw new IllegalStateException("XSSF-only Ptg, should not be serialised");
    }

    @Override
    public Ref3DPxg copy() {
        return new Ref3DPxg(this);
    }
}

