/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xdgf.usermodel;

import com.microsoft.schemas.office.visio.x2012.main.PageType;
import com.microsoft.schemas.office.visio.x2012.main.PagesDocument;
import com.microsoft.schemas.office.visio.x2012.main.PagesType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import shadeio.poi.ooxml.POIXMLDocumentPart;
import shadeio.poi.ooxml.POIXMLException;
import shadeio.poi.openxml4j.opc.PackagePart;
import shadeio.poi.util.Internal;
import shadeio.poi.xdgf.exceptions.XDGFException;
import shadeio.poi.xdgf.usermodel.XDGFPage;
import shadeio.poi.xdgf.usermodel.XDGFPageContents;
import shadeio.poi.xdgf.xml.XDGFXMLDocumentPart;

public class XDGFPages
extends XDGFXMLDocumentPart {
    PagesType _pagesObject;
    List<XDGFPage> _pages = new ArrayList<XDGFPage>();

    public XDGFPages(PackagePart part) {
        super(part);
    }

    @Internal
    PagesType getXmlObject() {
        return this._pagesObject;
    }

    @Override
    protected void onDocumentRead() {
        try {
            try {
                this._pagesObject = PagesDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream()).getPages();
            }
            catch (IOException | XmlException e) {
                throw new POIXMLException(e);
            }
            for (PageType pageSettings : this._pagesObject.getPageArray()) {
                String relId = pageSettings.getRel().getId();
                POIXMLDocumentPart pageContentsPart = this.getRelationById(relId);
                if (pageContentsPart == null) {
                    throw new POIXMLException("PageSettings relationship for " + relId + " not found");
                }
                if (!(pageContentsPart instanceof XDGFPageContents)) {
                    throw new POIXMLException("Unexpected pages relationship for " + relId + ": " + pageContentsPart);
                }
                XDGFPageContents contents = (XDGFPageContents)pageContentsPart;
                XDGFPage page = new XDGFPage(pageSettings, contents, this._document, this);
                contents.onDocumentRead();
                this._pages.add(page);
            }
        }
        catch (POIXMLException e) {
            throw XDGFException.wrap(this, e);
        }
    }

    public List<XDGFPage> getPageList() {
        return Collections.unmodifiableList(this._pages);
    }
}

