/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xssf.usermodel;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTDxf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTNumFmt;
import shadeio.poi.ss.usermodel.BorderFormatting;
import shadeio.poi.ss.usermodel.DifferentialStyleProvider;
import shadeio.poi.ss.usermodel.ExcelNumberFormat;
import shadeio.poi.ss.usermodel.FontFormatting;
import shadeio.poi.ss.usermodel.PatternFormatting;
import shadeio.poi.xssf.usermodel.IndexedColorMap;
import shadeio.poi.xssf.usermodel.XSSFBorderFormatting;
import shadeio.poi.xssf.usermodel.XSSFFontFormatting;
import shadeio.poi.xssf.usermodel.XSSFPatternFormatting;

public class XSSFDxfStyleProvider
implements DifferentialStyleProvider {
    private final IndexedColorMap colorMap;
    private final BorderFormatting border;
    private final FontFormatting font;
    private final ExcelNumberFormat number;
    private final PatternFormatting fill;
    private final int stripeSize;

    public XSSFDxfStyleProvider(CTDxf dxf, int stripeSize, IndexedColorMap colorMap) {
        this.stripeSize = stripeSize;
        this.colorMap = colorMap;
        if (dxf == null) {
            this.border = null;
            this.font = null;
            this.number = null;
            this.fill = null;
        } else {
            this.border = dxf.isSetBorder() ? new XSSFBorderFormatting(dxf.getBorder(), colorMap) : null;
            FontFormatting fontFormatting = this.font = dxf.isSetFont() ? new XSSFFontFormatting(dxf.getFont(), colorMap) : null;
            if (dxf.isSetNumFmt()) {
                CTNumFmt numFmt = dxf.getNumFmt();
                this.number = new ExcelNumberFormat((int)numFmt.getNumFmtId(), numFmt.getFormatCode());
            } else {
                this.number = null;
            }
            this.fill = dxf.isSetFill() ? new XSSFPatternFormatting(dxf.getFill(), colorMap) : null;
        }
    }

    @Override
    public BorderFormatting getBorderFormatting() {
        return this.border;
    }

    @Override
    public FontFormatting getFontFormatting() {
        return this.font;
    }

    @Override
    public ExcelNumberFormat getNumberFormat() {
        return this.number;
    }

    @Override
    public PatternFormatting getPatternFormatting() {
        return this.fill;
    }

    @Override
    public int getStripeSize() {
        return this.stripeSize;
    }
}

