/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.AWSAccount;
import com.datadog.api.v1.client.model.AWSAccountCreateResponse;
import com.datadog.api.v1.client.model.AWSAccountListResponse;
import com.datadog.api.v1.client.model.AWSTagFilterCreateRequest;
import com.datadog.api.v1.client.model.AWSTagFilterDeleteRequest;
import com.datadog.api.v1.client.model.AWSTagFilterListResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class AwsIntegrationApi {
    private ApiClient apiClient;

    public AwsIntegrationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AwsIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<AWSAccountCreateResponse> createAWSAccountWithHttpInfo(AWSAccount body) throws ApiException {
        AWSAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAWSAccount");
        }
        String localVarPath = "/api/v1/integration/aws";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAWSAccount");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<AWSAccountCreateResponse> localVarReturnType = new GenericType<AWSAccountCreateResponse>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.createAWSAccount", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateAWSAccountRequest createAWSAccount() throws ApiException {
        return new APIcreateAWSAccountRequest();
    }

    private ApiResponse<Object> createAWSTagFilterWithHttpInfo(AWSTagFilterCreateRequest body) throws ApiException {
        AWSTagFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAWSTagFilter");
        }
        String localVarPath = "/api/v1/integration/aws/filtering";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createAWSTagFilter");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.createAWSTagFilter", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateAWSTagFilterRequest createAWSTagFilter() throws ApiException {
        return new APIcreateAWSTagFilterRequest();
    }

    private ApiResponse<AWSAccountCreateResponse> createNewAWSExternalIDWithHttpInfo(AWSAccount body) throws ApiException {
        AWSAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createNewAWSExternalID");
        }
        String localVarPath = "/api/v1/integration/aws/generate_new_external_id";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createNewAWSExternalID");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<AWSAccountCreateResponse> localVarReturnType = new GenericType<AWSAccountCreateResponse>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.createNewAWSExternalID", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateNewAWSExternalIDRequest createNewAWSExternalID() throws ApiException {
        return new APIcreateNewAWSExternalIDRequest();
    }

    private ApiResponse<Object> deleteAWSAccountWithHttpInfo(AWSAccount body) throws ApiException {
        AWSAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteAWSAccount");
        }
        String localVarPath = "/api/v1/integration/aws";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAWSAccount");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.deleteAWSAccount", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIdeleteAWSAccountRequest deleteAWSAccount() throws ApiException {
        return new APIdeleteAWSAccountRequest();
    }

    private ApiResponse<Object> deleteAWSTagFilterWithHttpInfo(AWSTagFilterDeleteRequest body) throws ApiException {
        AWSTagFilterDeleteRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteAWSTagFilter");
        }
        String localVarPath = "/api/v1/integration/aws/filtering";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteAWSTagFilter");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.deleteAWSTagFilter", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIdeleteAWSTagFilterRequest deleteAWSTagFilter() throws ApiException {
        return new APIdeleteAWSTagFilterRequest();
    }

    private ApiResponse<AWSAccountListResponse> listAWSAccountsWithHttpInfo(String accountId, String roleName, String accessKeyId) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/aws";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "account_id", accountId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "role_name", roleName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "access_key_id", accessKeyId));
        localVarHeaderParams.put("DD-OPERATION-ID", "listAWSAccounts");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<AWSAccountListResponse> localVarReturnType = new GenericType<AWSAccountListResponse>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.listAWSAccounts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistAWSAccountsRequest listAWSAccounts() throws ApiException {
        return new APIlistAWSAccountsRequest();
    }

    private ApiResponse<AWSTagFilterListResponse> listAWSTagFiltersWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listAWSTagFilters");
        }
        String localVarPath = "/api/v1/integration/aws/filtering";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "account_id", accountId));
        localVarHeaderParams.put("DD-OPERATION-ID", "listAWSTagFilters");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<AWSTagFilterListResponse> localVarReturnType = new GenericType<AWSTagFilterListResponse>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.listAWSTagFilters", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistAWSTagFiltersRequest listAWSTagFilters() throws ApiException {
        return new APIlistAWSTagFiltersRequest();
    }

    private ApiResponse<List<String>> listAvailableAWSNamespacesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/integration/aws/available_namespace_rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listAvailableAWSNamespaces");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<List<String>> localVarReturnType = new GenericType<List<String>>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.listAvailableAWSNamespaces", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistAvailableAWSNamespacesRequest listAvailableAWSNamespaces() throws ApiException {
        return new APIlistAvailableAWSNamespacesRequest();
    }

    private ApiResponse<Object> updateAWSAccountWithHttpInfo(AWSAccount body, String accountId, String roleName, String accessKeyId) throws ApiException {
        AWSAccount localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAWSAccount");
        }
        String localVarPath = "/api/v1/integration/aws";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "account_id", accountId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "role_name", roleName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "access_key_id", accessKeyId));
        localVarHeaderParams.put("DD-OPERATION-ID", "updateAWSAccount");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("AwsIntegrationApi.updateAWSAccount", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateAWSAccountRequest updateAWSAccount() throws ApiException {
        return new APIupdateAWSAccountRequest();
    }

    public class APIupdateAWSAccountRequest {
        private AWSAccount body;
        private String accountId;
        private String roleName;
        private String accessKeyId;

        private APIupdateAWSAccountRequest() {
        }

        public APIupdateAWSAccountRequest body(AWSAccount body) {
            this.body = body;
            return this;
        }

        public APIupdateAWSAccountRequest accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public APIupdateAWSAccountRequest roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public APIupdateAWSAccountRequest accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Object execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return AwsIntegrationApi.this.updateAWSAccountWithHttpInfo(this.body, this.accountId, this.roleName, this.accessKeyId);
        }
    }

    public class APIlistAvailableAWSNamespacesRequest {
        private APIlistAvailableAWSNamespacesRequest() {
        }

        public List<String> execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<List<String>> executeWithHttpInfo() throws ApiException {
            return AwsIntegrationApi.this.listAvailableAWSNamespacesWithHttpInfo();
        }
    }

    public class APIlistAWSTagFiltersRequest {
        private String accountId;

        private APIlistAWSTagFiltersRequest() {
        }

        public APIlistAWSTagFiltersRequest accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public AWSTagFilterListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<AWSTagFilterListResponse> executeWithHttpInfo() throws ApiException {
            return AwsIntegrationApi.this.listAWSTagFiltersWithHttpInfo(this.accountId);
        }
    }

    public class APIlistAWSAccountsRequest {
        private String accountId;
        private String roleName;
        private String accessKeyId;

        private APIlistAWSAccountsRequest() {
        }

        public APIlistAWSAccountsRequest accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public APIlistAWSAccountsRequest roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public APIlistAWSAccountsRequest accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public AWSAccountListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<AWSAccountListResponse> executeWithHttpInfo() throws ApiException {
            return AwsIntegrationApi.this.listAWSAccountsWithHttpInfo(this.accountId, this.roleName, this.accessKeyId);
        }
    }

    public class APIdeleteAWSTagFilterRequest {
        private AWSTagFilterDeleteRequest body;

        private APIdeleteAWSTagFilterRequest() {
        }

        public APIdeleteAWSTagFilterRequest body(AWSTagFilterDeleteRequest body) {
            this.body = body;
            return this;
        }

        public Object execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return AwsIntegrationApi.this.deleteAWSTagFilterWithHttpInfo(this.body);
        }
    }

    public class APIdeleteAWSAccountRequest {
        private AWSAccount body;

        private APIdeleteAWSAccountRequest() {
        }

        public APIdeleteAWSAccountRequest body(AWSAccount body) {
            this.body = body;
            return this;
        }

        public Object execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return AwsIntegrationApi.this.deleteAWSAccountWithHttpInfo(this.body);
        }
    }

    public class APIcreateNewAWSExternalIDRequest {
        private AWSAccount body;

        private APIcreateNewAWSExternalIDRequest() {
        }

        public APIcreateNewAWSExternalIDRequest body(AWSAccount body) {
            this.body = body;
            return this;
        }

        public AWSAccountCreateResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<AWSAccountCreateResponse> executeWithHttpInfo() throws ApiException {
            return AwsIntegrationApi.this.createNewAWSExternalIDWithHttpInfo(this.body);
        }
    }

    public class APIcreateAWSTagFilterRequest {
        private AWSTagFilterCreateRequest body;

        private APIcreateAWSTagFilterRequest() {
        }

        public APIcreateAWSTagFilterRequest body(AWSTagFilterCreateRequest body) {
            this.body = body;
            return this;
        }

        public Object execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Object> executeWithHttpInfo() throws ApiException {
            return AwsIntegrationApi.this.createAWSTagFilterWithHttpInfo(this.body);
        }
    }

    public class APIcreateAWSAccountRequest {
        private AWSAccount body;

        private APIcreateAWSAccountRequest() {
        }

        public APIcreateAWSAccountRequest body(AWSAccount body) {
            this.body = body;
            return this;
        }

        public AWSAccountCreateResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<AWSAccountCreateResponse> executeWithHttpInfo() throws ApiException {
            return AwsIntegrationApi.this.createAWSAccountWithHttpInfo(this.body);
        }
    }
}

