/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.IdpResponse;
import com.datadog.api.v1.client.model.Organization;
import com.datadog.api.v1.client.model.OrganizationCreateBody;
import com.datadog.api.v1.client.model.OrganizationCreateResponse;
import com.datadog.api.v1.client.model.OrganizationListResponse;
import com.datadog.api.v1.client.model.OrganizationResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class OrganizationsApi {
    private ApiClient apiClient;

    public OrganizationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrganizationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<OrganizationCreateResponse> createChildOrgWithHttpInfo(OrganizationCreateBody body) throws ApiException {
        OrganizationCreateBody localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createChildOrg");
        }
        String localVarPath = "/api/v1/org";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createChildOrg");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<OrganizationCreateResponse> localVarReturnType = new GenericType<OrganizationCreateResponse>(){};
        return this.apiClient.invokeAPI("OrganizationsApi.createChildOrg", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateChildOrgRequest createChildOrg() throws ApiException {
        return new APIcreateChildOrgRequest();
    }

    private ApiResponse<OrganizationResponse> getOrgWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getOrg");
        }
        String localVarPath = "/api/v1/org/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getOrg");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<OrganizationResponse> localVarReturnType = new GenericType<OrganizationResponse>(){};
        return this.apiClient.invokeAPI("OrganizationsApi.getOrg", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetOrgRequest getOrg(String publicId) throws ApiException {
        return new APIgetOrgRequest(publicId);
    }

    private ApiResponse<OrganizationListResponse> listOrgsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/org";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listOrgs");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<OrganizationListResponse> localVarReturnType = new GenericType<OrganizationListResponse>(){};
        return this.apiClient.invokeAPI("OrganizationsApi.listOrgs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistOrgsRequest listOrgs() throws ApiException {
        return new APIlistOrgsRequest();
    }

    private ApiResponse<OrganizationResponse> updateOrgWithHttpInfo(String publicId, Organization body) throws ApiException {
        Organization localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateOrg");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOrg");
        }
        String localVarPath = "/api/v1/org/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateOrg");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<OrganizationResponse> localVarReturnType = new GenericType<OrganizationResponse>(){};
        return this.apiClient.invokeAPI("OrganizationsApi.updateOrg", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateOrgRequest updateOrg(String publicId) throws ApiException {
        return new APIupdateOrgRequest(publicId);
    }

    private ApiResponse<IdpResponse> uploadIdPForOrgWithHttpInfo(String publicId, File idpFile) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling uploadIdPForOrg");
        }
        if (idpFile == null) {
            throw new ApiException(400, "Missing the required parameter 'idpFile' when calling uploadIdPForOrg");
        }
        String localVarPath = "/api/v1/org/{public_id}/idp_metadata".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "uploadIdPForOrg");
        if (idpFile != null) {
            localVarFormParams.put("idp_file", idpFile);
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IdpResponse> localVarReturnType = new GenericType<IdpResponse>(){};
        return this.apiClient.invokeAPI("OrganizationsApi.uploadIdPForOrg", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIuploadIdPForOrgRequest uploadIdPForOrg(String publicId) throws ApiException {
        return new APIuploadIdPForOrgRequest(publicId);
    }

    public class APIuploadIdPForOrgRequest {
        private String publicId;
        private File idpFile;

        private APIuploadIdPForOrgRequest(String publicId) {
            this.publicId = publicId;
        }

        public APIuploadIdPForOrgRequest idpFile(File idpFile) {
            this.idpFile = idpFile;
            return this;
        }

        public IdpResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IdpResponse> executeWithHttpInfo() throws ApiException {
            return OrganizationsApi.this.uploadIdPForOrgWithHttpInfo(this.publicId, this.idpFile);
        }
    }

    public class APIupdateOrgRequest {
        private String publicId;
        private Organization body;

        private APIupdateOrgRequest(String publicId) {
            this.publicId = publicId;
        }

        public APIupdateOrgRequest body(Organization body) {
            this.body = body;
            return this;
        }

        public OrganizationResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<OrganizationResponse> executeWithHttpInfo() throws ApiException {
            return OrganizationsApi.this.updateOrgWithHttpInfo(this.publicId, this.body);
        }
    }

    public class APIlistOrgsRequest {
        private APIlistOrgsRequest() {
        }

        public OrganizationListResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<OrganizationListResponse> executeWithHttpInfo() throws ApiException {
            return OrganizationsApi.this.listOrgsWithHttpInfo();
        }
    }

    public class APIgetOrgRequest {
        private String publicId;

        private APIgetOrgRequest(String publicId) {
            this.publicId = publicId;
        }

        public OrganizationResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<OrganizationResponse> executeWithHttpInfo() throws ApiException {
            return OrganizationsApi.this.getOrgWithHttpInfo(this.publicId);
        }
    }

    public class APIcreateChildOrgRequest {
        private OrganizationCreateBody body;

        private APIcreateChildOrgRequest() {
        }

        public APIcreateChildOrgRequest body(OrganizationCreateBody body) {
            this.body = body;
            return this;
        }

        public OrganizationCreateResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<OrganizationCreateResponse> executeWithHttpInfo() throws ApiException {
            return OrganizationsApi.this.createChildOrgWithHttpInfo(this.body);
        }
    }
}

