/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.GraphSnapshot;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class SnapshotsApi {
    private ApiClient apiClient;

    public SnapshotsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SnapshotsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<GraphSnapshot> getGraphSnapshotWithHttpInfo(Long start, Long end, String metricQuery, String eventQuery, String graphDef, String title) throws ApiException {
        Object localVarPostBody = null;
        if (start == null) {
            throw new ApiException(400, "Missing the required parameter 'start' when calling getGraphSnapshot");
        }
        if (end == null) {
            throw new ApiException(400, "Missing the required parameter 'end' when calling getGraphSnapshot");
        }
        String localVarPath = "/api/v1/graph/snapshot";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "metric_query", metricQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start", start));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end", end));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "event_query", eventQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "graph_def", graphDef));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "title", title));
        localVarHeaderParams.put("DD-OPERATION-ID", "getGraphSnapshot");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<GraphSnapshot> localVarReturnType = new GenericType<GraphSnapshot>(){};
        return this.apiClient.invokeAPI("SnapshotsApi.getGraphSnapshot", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetGraphSnapshotRequest getGraphSnapshot() throws ApiException {
        return new APIgetGraphSnapshotRequest();
    }

    public class APIgetGraphSnapshotRequest {
        private Long start;
        private Long end;
        private String metricQuery;
        private String eventQuery;
        private String graphDef;
        private String title;

        private APIgetGraphSnapshotRequest() {
        }

        public APIgetGraphSnapshotRequest start(Long start) {
            this.start = start;
            return this;
        }

        public APIgetGraphSnapshotRequest end(Long end) {
            this.end = end;
            return this;
        }

        public APIgetGraphSnapshotRequest metricQuery(String metricQuery) {
            this.metricQuery = metricQuery;
            return this;
        }

        public APIgetGraphSnapshotRequest eventQuery(String eventQuery) {
            this.eventQuery = eventQuery;
            return this;
        }

        public APIgetGraphSnapshotRequest graphDef(String graphDef) {
            this.graphDef = graphDef;
            return this;
        }

        public APIgetGraphSnapshotRequest title(String title) {
            this.title = title;
            return this;
        }

        public GraphSnapshot execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<GraphSnapshot> executeWithHttpInfo() throws ApiException {
            return SnapshotsApi.this.getGraphSnapshotWithHttpInfo(this.start, this.end, this.metricQuery, this.eventQuery, this.graphDef, this.title);
        }
    }
}

