/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.SyntheticsAPITestResultFull;
import com.datadog.api.v1.client.model.SyntheticsBrowserTestResultFull;
import com.datadog.api.v1.client.model.SyntheticsCITestBody;
import com.datadog.api.v1.client.model.SyntheticsDeleteTestsPayload;
import com.datadog.api.v1.client.model.SyntheticsDeleteTestsResponse;
import com.datadog.api.v1.client.model.SyntheticsGetAPITestLatestResultsResponse;
import com.datadog.api.v1.client.model.SyntheticsGetBrowserTestLatestResultsResponse;
import com.datadog.api.v1.client.model.SyntheticsGlobalVariable;
import com.datadog.api.v1.client.model.SyntheticsListTestsResponse;
import com.datadog.api.v1.client.model.SyntheticsLocations;
import com.datadog.api.v1.client.model.SyntheticsPrivateLocation;
import com.datadog.api.v1.client.model.SyntheticsPrivateLocationCreationResponse;
import com.datadog.api.v1.client.model.SyntheticsTestDetails;
import com.datadog.api.v1.client.model.SyntheticsTriggerCITestsResponse;
import com.datadog.api.v1.client.model.SyntheticsUpdateTestPauseStatusPayload;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class SyntheticsApi {
    private ApiClient apiClient;

    public SyntheticsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SyntheticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<SyntheticsGlobalVariable> createGlobalVariableWithHttpInfo(SyntheticsGlobalVariable body) throws ApiException {
        SyntheticsGlobalVariable localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createGlobalVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGlobalVariable> localVarReturnType = new GenericType<SyntheticsGlobalVariable>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.createGlobalVariable", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateGlobalVariableRequest createGlobalVariable() throws ApiException {
        return new APIcreateGlobalVariableRequest();
    }

    private ApiResponse<SyntheticsPrivateLocationCreationResponse> createPrivateLocationWithHttpInfo(SyntheticsPrivateLocation body) throws ApiException {
        SyntheticsPrivateLocation localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createPrivateLocation");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsPrivateLocationCreationResponse> localVarReturnType = new GenericType<SyntheticsPrivateLocationCreationResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.createPrivateLocation", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreatePrivateLocationRequest createPrivateLocation() throws ApiException {
        return new APIcreatePrivateLocationRequest();
    }

    private ApiResponse<SyntheticsTestDetails> createTestWithHttpInfo(SyntheticsTestDetails body) throws ApiException {
        SyntheticsTestDetails localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTest");
        }
        String localVarPath = "/api/v1/synthetics/tests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsTestDetails> localVarReturnType = new GenericType<SyntheticsTestDetails>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.createTest", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateTestRequest createTest() throws ApiException {
        return new APIcreateTestRequest();
    }

    private ApiResponse<Void> deleteGlobalVariableWithHttpInfo(String variableId) throws ApiException {
        Object localVarPostBody = null;
        if (variableId == null) {
            throw new ApiException(400, "Missing the required parameter 'variableId' when calling deleteGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteGlobalVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("SyntheticsApi.deleteGlobalVariable", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeleteGlobalVariableRequest deleteGlobalVariable(String variableId) throws ApiException {
        return new APIdeleteGlobalVariableRequest(variableId);
    }

    private ApiResponse<Void> deletePrivateLocationWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling deletePrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deletePrivateLocation");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("SyntheticsApi.deletePrivateLocation", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeletePrivateLocationRequest deletePrivateLocation(String locationId) throws ApiException {
        return new APIdeletePrivateLocationRequest(locationId);
    }

    private ApiResponse<SyntheticsDeleteTestsResponse> deleteTestsWithHttpInfo(SyntheticsDeleteTestsPayload body) throws ApiException {
        SyntheticsDeleteTestsPayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling deleteTests");
        }
        String localVarPath = "/api/v1/synthetics/tests/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteTests");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsDeleteTestsResponse> localVarReturnType = new GenericType<SyntheticsDeleteTestsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.deleteTests", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIdeleteTestsRequest deleteTests() throws ApiException {
        return new APIdeleteTestsRequest();
    }

    private ApiResponse<SyntheticsGlobalVariable> editGlobalVariableWithHttpInfo(String variableId, SyntheticsGlobalVariable body) throws ApiException {
        SyntheticsGlobalVariable localVarPostBody = body;
        if (variableId == null) {
            throw new ApiException(400, "Missing the required parameter 'variableId' when calling editGlobalVariable");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling editGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "editGlobalVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGlobalVariable> localVarReturnType = new GenericType<SyntheticsGlobalVariable>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.editGlobalVariable", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIeditGlobalVariableRequest editGlobalVariable(String variableId) throws ApiException {
        return new APIeditGlobalVariableRequest(variableId);
    }

    private ApiResponse<SyntheticsGetAPITestLatestResultsResponse> getAPITestLatestResultsWithHttpInfo(String publicId, Long fromTs, Long toTs, List<String> probeDc) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITestLatestResults");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/results".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "probe_dc", probeDc));
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPITestLatestResults");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGetAPITestLatestResultsResponse> localVarReturnType = new GenericType<SyntheticsGetAPITestLatestResultsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getAPITestLatestResults", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetAPITestLatestResultsRequest getAPITestLatestResults(String publicId) throws ApiException {
        return new APIgetAPITestLatestResultsRequest(publicId);
    }

    private ApiResponse<SyntheticsAPITestResultFull> getAPITestResultWithHttpInfo(String publicId, String resultId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getAPITestResult");
        }
        if (resultId == null) {
            throw new ApiException(400, "Missing the required parameter 'resultId' when calling getAPITestResult");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/results/{result_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString())).replaceAll("\\{result_id\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getAPITestResult");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsAPITestResultFull> localVarReturnType = new GenericType<SyntheticsAPITestResultFull>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getAPITestResult", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetAPITestResultRequest getAPITestResult(String publicId, String resultId) throws ApiException {
        return new APIgetAPITestResultRequest(publicId, resultId);
    }

    private ApiResponse<SyntheticsTestDetails> getBrowserTestWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getBrowserTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsTestDetails> localVarReturnType = new GenericType<SyntheticsTestDetails>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getBrowserTest", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetBrowserTestRequest getBrowserTest(String publicId) throws ApiException {
        return new APIgetBrowserTestRequest(publicId);
    }

    private ApiResponse<SyntheticsGetBrowserTestLatestResultsResponse> getBrowserTestLatestResultsWithHttpInfo(String publicId, Long fromTs, Long toTs, List<String> probeDc) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTestLatestResults");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}/results".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from_ts", fromTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to_ts", toTs));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "probe_dc", probeDc));
        localVarHeaderParams.put("DD-OPERATION-ID", "getBrowserTestLatestResults");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGetBrowserTestLatestResultsResponse> localVarReturnType = new GenericType<SyntheticsGetBrowserTestLatestResultsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getBrowserTestLatestResults", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetBrowserTestLatestResultsRequest getBrowserTestLatestResults(String publicId) throws ApiException {
        return new APIgetBrowserTestLatestResultsRequest(publicId);
    }

    private ApiResponse<SyntheticsBrowserTestResultFull> getBrowserTestResultWithHttpInfo(String publicId, String resultId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getBrowserTestResult");
        }
        if (resultId == null) {
            throw new ApiException(400, "Missing the required parameter 'resultId' when calling getBrowserTestResult");
        }
        String localVarPath = "/api/v1/synthetics/tests/browser/{public_id}/results/{result_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString())).replaceAll("\\{result_id\\}", this.apiClient.escapeString(resultId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getBrowserTestResult");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsBrowserTestResultFull> localVarReturnType = new GenericType<SyntheticsBrowserTestResultFull>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getBrowserTestResult", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetBrowserTestResultRequest getBrowserTestResult(String publicId, String resultId) throws ApiException {
        return new APIgetBrowserTestResultRequest(publicId, resultId);
    }

    private ApiResponse<SyntheticsGlobalVariable> getGlobalVariableWithHttpInfo(String variableId) throws ApiException {
        Object localVarPostBody = null;
        if (variableId == null) {
            throw new ApiException(400, "Missing the required parameter 'variableId' when calling getGlobalVariable");
        }
        String localVarPath = "/api/v1/synthetics/variables/{variable_id}".replaceAll("\\{variable_id\\}", this.apiClient.escapeString(variableId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getGlobalVariable");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsGlobalVariable> localVarReturnType = new GenericType<SyntheticsGlobalVariable>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getGlobalVariable", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetGlobalVariableRequest getGlobalVariable(String variableId) throws ApiException {
        return new APIgetGlobalVariableRequest(variableId);
    }

    private ApiResponse<SyntheticsPrivateLocation> getPrivateLocationWithHttpInfo(String locationId) throws ApiException {
        Object localVarPostBody = null;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling getPrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getPrivateLocation");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsPrivateLocation> localVarReturnType = new GenericType<SyntheticsPrivateLocation>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getPrivateLocation", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetPrivateLocationRequest getPrivateLocation(String locationId) throws ApiException {
        return new APIgetPrivateLocationRequest(locationId);
    }

    private ApiResponse<SyntheticsTestDetails> getTestWithHttpInfo(String publicId) throws ApiException {
        Object localVarPostBody = null;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling getTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsTestDetails> localVarReturnType = new GenericType<SyntheticsTestDetails>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.getTest", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetTestRequest getTest(String publicId) throws ApiException {
        return new APIgetTestRequest(publicId);
    }

    private ApiResponse<SyntheticsLocations> listLocationsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/locations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLocations");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsLocations> localVarReturnType = new GenericType<SyntheticsLocations>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.listLocations", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistLocationsRequest listLocations() throws ApiException {
        return new APIlistLocationsRequest();
    }

    private ApiResponse<SyntheticsListTestsResponse> listTestsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/synthetics/tests";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listTests");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsListTestsResponse> localVarReturnType = new GenericType<SyntheticsListTestsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.listTests", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistTestsRequest listTests() throws ApiException {
        return new APIlistTestsRequest();
    }

    private ApiResponse<SyntheticsTriggerCITestsResponse> triggerCITestsWithHttpInfo(SyntheticsCITestBody body) throws ApiException {
        SyntheticsCITestBody localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling triggerCITests");
        }
        String localVarPath = "/api/v1/synthetics/tests/trigger/ci";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "triggerCITests");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsTriggerCITestsResponse> localVarReturnType = new GenericType<SyntheticsTriggerCITestsResponse>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.triggerCITests", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APItriggerCITestsRequest triggerCITests() throws ApiException {
        return new APItriggerCITestsRequest();
    }

    private ApiResponse<SyntheticsPrivateLocation> updatePrivateLocationWithHttpInfo(String locationId, SyntheticsPrivateLocation body) throws ApiException {
        SyntheticsPrivateLocation localVarPostBody = body;
        if (locationId == null) {
            throw new ApiException(400, "Missing the required parameter 'locationId' when calling updatePrivateLocation");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePrivateLocation");
        }
        String localVarPath = "/api/v1/synthetics/private-locations/{location_id}".replaceAll("\\{location_id\\}", this.apiClient.escapeString(locationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updatePrivateLocation");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsPrivateLocation> localVarReturnType = new GenericType<SyntheticsPrivateLocation>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.updatePrivateLocation", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdatePrivateLocationRequest updatePrivateLocation(String locationId) throws ApiException {
        return new APIupdatePrivateLocationRequest(locationId);
    }

    private ApiResponse<SyntheticsTestDetails> updateTestWithHttpInfo(String publicId, SyntheticsTestDetails body) throws ApiException {
        SyntheticsTestDetails localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateTest");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTest");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateTest");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<SyntheticsTestDetails> localVarReturnType = new GenericType<SyntheticsTestDetails>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.updateTest", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateTestRequest updateTest(String publicId) throws ApiException {
        return new APIupdateTestRequest(publicId);
    }

    private ApiResponse<Boolean> updateTestPauseStatusWithHttpInfo(String publicId, SyntheticsUpdateTestPauseStatusPayload body) throws ApiException {
        SyntheticsUpdateTestPauseStatusPayload localVarPostBody = body;
        if (publicId == null) {
            throw new ApiException(400, "Missing the required parameter 'publicId' when calling updateTestPauseStatus");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateTestPauseStatus");
        }
        String localVarPath = "/api/v1/synthetics/tests/{public_id}/status".replaceAll("\\{public_id\\}", this.apiClient.escapeString(publicId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateTestPauseStatus");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<Boolean> localVarReturnType = new GenericType<Boolean>(){};
        return this.apiClient.invokeAPI("SyntheticsApi.updateTestPauseStatus", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateTestPauseStatusRequest updateTestPauseStatus(String publicId) throws ApiException {
        return new APIupdateTestPauseStatusRequest(publicId);
    }

    public class APIupdateTestPauseStatusRequest {
        private String publicId;
        private SyntheticsUpdateTestPauseStatusPayload body;

        private APIupdateTestPauseStatusRequest(String publicId) {
            this.publicId = publicId;
        }

        public APIupdateTestPauseStatusRequest body(SyntheticsUpdateTestPauseStatusPayload body) {
            this.body = body;
            return this;
        }

        public Boolean execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Boolean> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.updateTestPauseStatusWithHttpInfo(this.publicId, this.body);
        }
    }

    public class APIupdateTestRequest {
        private String publicId;
        private SyntheticsTestDetails body;

        private APIupdateTestRequest(String publicId) {
            this.publicId = publicId;
        }

        public APIupdateTestRequest body(SyntheticsTestDetails body) {
            this.body = body;
            return this;
        }

        public SyntheticsTestDetails execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsTestDetails> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.updateTestWithHttpInfo(this.publicId, this.body);
        }
    }

    public class APIupdatePrivateLocationRequest {
        private String locationId;
        private SyntheticsPrivateLocation body;

        private APIupdatePrivateLocationRequest(String locationId) {
            this.locationId = locationId;
        }

        public APIupdatePrivateLocationRequest body(SyntheticsPrivateLocation body) {
            this.body = body;
            return this;
        }

        public SyntheticsPrivateLocation execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsPrivateLocation> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.updatePrivateLocationWithHttpInfo(this.locationId, this.body);
        }
    }

    public class APItriggerCITestsRequest {
        private SyntheticsCITestBody body;

        private APItriggerCITestsRequest() {
        }

        public APItriggerCITestsRequest body(SyntheticsCITestBody body) {
            this.body = body;
            return this;
        }

        public SyntheticsTriggerCITestsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsTriggerCITestsResponse> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.triggerCITestsWithHttpInfo(this.body);
        }
    }

    public class APIlistTestsRequest {
        private APIlistTestsRequest() {
        }

        public SyntheticsListTestsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsListTestsResponse> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.listTestsWithHttpInfo();
        }
    }

    public class APIlistLocationsRequest {
        private APIlistLocationsRequest() {
        }

        public SyntheticsLocations execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsLocations> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.listLocationsWithHttpInfo();
        }
    }

    public class APIgetTestRequest {
        private String publicId;

        private APIgetTestRequest(String publicId) {
            this.publicId = publicId;
        }

        public SyntheticsTestDetails execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsTestDetails> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getTestWithHttpInfo(this.publicId);
        }
    }

    public class APIgetPrivateLocationRequest {
        private String locationId;

        private APIgetPrivateLocationRequest(String locationId) {
            this.locationId = locationId;
        }

        public SyntheticsPrivateLocation execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsPrivateLocation> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getPrivateLocationWithHttpInfo(this.locationId);
        }
    }

    public class APIgetGlobalVariableRequest {
        private String variableId;

        private APIgetGlobalVariableRequest(String variableId) {
            this.variableId = variableId;
        }

        public SyntheticsGlobalVariable execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsGlobalVariable> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getGlobalVariableWithHttpInfo(this.variableId);
        }
    }

    public class APIgetBrowserTestResultRequest {
        private String publicId;
        private String resultId;

        private APIgetBrowserTestResultRequest(String publicId, String resultId) {
            this.publicId = publicId;
            this.resultId = resultId;
        }

        public SyntheticsBrowserTestResultFull execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsBrowserTestResultFull> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getBrowserTestResultWithHttpInfo(this.publicId, this.resultId);
        }
    }

    public class APIgetBrowserTestLatestResultsRequest {
        private String publicId;
        private Long fromTs;
        private Long toTs;
        private List<String> probeDc;

        private APIgetBrowserTestLatestResultsRequest(String publicId) {
            this.publicId = publicId;
        }

        public APIgetBrowserTestLatestResultsRequest fromTs(Long fromTs) {
            this.fromTs = fromTs;
            return this;
        }

        public APIgetBrowserTestLatestResultsRequest toTs(Long toTs) {
            this.toTs = toTs;
            return this;
        }

        public APIgetBrowserTestLatestResultsRequest probeDc(List<String> probeDc) {
            this.probeDc = probeDc;
            return this;
        }

        public SyntheticsGetBrowserTestLatestResultsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsGetBrowserTestLatestResultsResponse> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getBrowserTestLatestResultsWithHttpInfo(this.publicId, this.fromTs, this.toTs, this.probeDc);
        }
    }

    public class APIgetBrowserTestRequest {
        private String publicId;

        private APIgetBrowserTestRequest(String publicId) {
            this.publicId = publicId;
        }

        public SyntheticsTestDetails execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsTestDetails> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getBrowserTestWithHttpInfo(this.publicId);
        }
    }

    public class APIgetAPITestResultRequest {
        private String publicId;
        private String resultId;

        private APIgetAPITestResultRequest(String publicId, String resultId) {
            this.publicId = publicId;
            this.resultId = resultId;
        }

        public SyntheticsAPITestResultFull execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsAPITestResultFull> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getAPITestResultWithHttpInfo(this.publicId, this.resultId);
        }
    }

    public class APIgetAPITestLatestResultsRequest {
        private String publicId;
        private Long fromTs;
        private Long toTs;
        private List<String> probeDc;

        private APIgetAPITestLatestResultsRequest(String publicId) {
            this.publicId = publicId;
        }

        public APIgetAPITestLatestResultsRequest fromTs(Long fromTs) {
            this.fromTs = fromTs;
            return this;
        }

        public APIgetAPITestLatestResultsRequest toTs(Long toTs) {
            this.toTs = toTs;
            return this;
        }

        public APIgetAPITestLatestResultsRequest probeDc(List<String> probeDc) {
            this.probeDc = probeDc;
            return this;
        }

        public SyntheticsGetAPITestLatestResultsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsGetAPITestLatestResultsResponse> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.getAPITestLatestResultsWithHttpInfo(this.publicId, this.fromTs, this.toTs, this.probeDc);
        }
    }

    public class APIeditGlobalVariableRequest {
        private String variableId;
        private SyntheticsGlobalVariable body;

        private APIeditGlobalVariableRequest(String variableId) {
            this.variableId = variableId;
        }

        public APIeditGlobalVariableRequest body(SyntheticsGlobalVariable body) {
            this.body = body;
            return this;
        }

        public SyntheticsGlobalVariable execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsGlobalVariable> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.editGlobalVariableWithHttpInfo(this.variableId, this.body);
        }
    }

    public class APIdeleteTestsRequest {
        private SyntheticsDeleteTestsPayload body;

        private APIdeleteTestsRequest() {
        }

        public APIdeleteTestsRequest body(SyntheticsDeleteTestsPayload body) {
            this.body = body;
            return this;
        }

        public SyntheticsDeleteTestsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsDeleteTestsResponse> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.deleteTestsWithHttpInfo(this.body);
        }
    }

    public class APIdeletePrivateLocationRequest {
        private String locationId;

        private APIdeletePrivateLocationRequest(String locationId) {
            this.locationId = locationId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.deletePrivateLocationWithHttpInfo(this.locationId);
        }
    }

    public class APIdeleteGlobalVariableRequest {
        private String variableId;

        private APIdeleteGlobalVariableRequest(String variableId) {
            this.variableId = variableId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.deleteGlobalVariableWithHttpInfo(this.variableId);
        }
    }

    public class APIcreateTestRequest {
        private SyntheticsTestDetails body;

        private APIcreateTestRequest() {
        }

        public APIcreateTestRequest body(SyntheticsTestDetails body) {
            this.body = body;
            return this;
        }

        public SyntheticsTestDetails execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsTestDetails> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.createTestWithHttpInfo(this.body);
        }
    }

    public class APIcreatePrivateLocationRequest {
        private SyntheticsPrivateLocation body;

        private APIcreatePrivateLocationRequest() {
        }

        public APIcreatePrivateLocationRequest body(SyntheticsPrivateLocation body) {
            this.body = body;
            return this;
        }

        public SyntheticsPrivateLocationCreationResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsPrivateLocationCreationResponse> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.createPrivateLocationWithHttpInfo(this.body);
        }
    }

    public class APIcreateGlobalVariableRequest {
        private SyntheticsGlobalVariable body;

        private APIcreateGlobalVariableRequest() {
        }

        public APIcreateGlobalVariableRequest body(SyntheticsGlobalVariable body) {
            this.body = body;
            return this;
        }

        public SyntheticsGlobalVariable execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<SyntheticsGlobalVariable> executeWithHttpInfo() throws ApiException {
            return SyntheticsApi.this.createGlobalVariableWithHttpInfo(this.body);
        }
    }
}

