/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.HostTags;
import com.datadog.api.v1.client.model.TagToHosts;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class TagsApi {
    private ApiClient apiClient;

    public TagsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TagsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<HostTags> createHostTagsWithHttpInfo(String hostName, HostTags body, String source) throws ApiException {
        HostTags localVarPostBody = body;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling createHostTags");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createHostTags");
        }
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        localVarHeaderParams.put("DD-OPERATION-ID", "createHostTags");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<HostTags> localVarReturnType = new GenericType<HostTags>(){};
        return this.apiClient.invokeAPI("TagsApi.createHostTags", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateHostTagsRequest createHostTags(String hostName) throws ApiException {
        return new APIcreateHostTagsRequest(hostName);
    }

    private ApiResponse<Void> deleteHostTagsWithHttpInfo(String hostName, String source) throws ApiException {
        Object localVarPostBody = null;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling deleteHostTags");
        }
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteHostTags");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("TagsApi.deleteHostTags", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeleteHostTagsRequest deleteHostTags(String hostName) throws ApiException {
        return new APIdeleteHostTagsRequest(hostName);
    }

    private ApiResponse<HostTags> getHostTagsWithHttpInfo(String hostName, String source) throws ApiException {
        Object localVarPostBody = null;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling getHostTags");
        }
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        localVarHeaderParams.put("DD-OPERATION-ID", "getHostTags");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<HostTags> localVarReturnType = new GenericType<HostTags>(){};
        return this.apiClient.invokeAPI("TagsApi.getHostTags", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetHostTagsRequest getHostTags(String hostName) throws ApiException {
        return new APIgetHostTagsRequest(hostName);
    }

    private ApiResponse<TagToHosts> listHostTagsWithHttpInfo(String source) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/tags/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        localVarHeaderParams.put("DD-OPERATION-ID", "listHostTags");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<TagToHosts> localVarReturnType = new GenericType<TagToHosts>(){};
        return this.apiClient.invokeAPI("TagsApi.listHostTags", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistHostTagsRequest listHostTags() throws ApiException {
        return new APIlistHostTagsRequest();
    }

    private ApiResponse<HostTags> updateHostTagsWithHttpInfo(String hostName, HostTags body, String source) throws ApiException {
        HostTags localVarPostBody = body;
        if (hostName == null) {
            throw new ApiException(400, "Missing the required parameter 'hostName' when calling updateHostTags");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateHostTags");
        }
        String localVarPath = "/api/v1/tags/hosts/{host_name}".replaceAll("\\{host_name\\}", this.apiClient.escapeString(hostName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "source", source));
        localVarHeaderParams.put("DD-OPERATION-ID", "updateHostTags");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<HostTags> localVarReturnType = new GenericType<HostTags>(){};
        return this.apiClient.invokeAPI("TagsApi.updateHostTags", localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateHostTagsRequest updateHostTags(String hostName) throws ApiException {
        return new APIupdateHostTagsRequest(hostName);
    }

    public class APIupdateHostTagsRequest {
        private String hostName;
        private HostTags body;
        private String source;

        private APIupdateHostTagsRequest(String hostName) {
            this.hostName = hostName;
        }

        public APIupdateHostTagsRequest body(HostTags body) {
            this.body = body;
            return this;
        }

        public APIupdateHostTagsRequest source(String source) {
            this.source = source;
            return this;
        }

        public HostTags execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<HostTags> executeWithHttpInfo() throws ApiException {
            return TagsApi.this.updateHostTagsWithHttpInfo(this.hostName, this.body, this.source);
        }
    }

    public class APIlistHostTagsRequest {
        private String source;

        private APIlistHostTagsRequest() {
        }

        public APIlistHostTagsRequest source(String source) {
            this.source = source;
            return this;
        }

        public TagToHosts execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<TagToHosts> executeWithHttpInfo() throws ApiException {
            return TagsApi.this.listHostTagsWithHttpInfo(this.source);
        }
    }

    public class APIgetHostTagsRequest {
        private String hostName;
        private String source;

        private APIgetHostTagsRequest(String hostName) {
            this.hostName = hostName;
        }

        public APIgetHostTagsRequest source(String source) {
            this.source = source;
            return this;
        }

        public HostTags execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<HostTags> executeWithHttpInfo() throws ApiException {
            return TagsApi.this.getHostTagsWithHttpInfo(this.hostName, this.source);
        }
    }

    public class APIdeleteHostTagsRequest {
        private String hostName;
        private String source;

        private APIdeleteHostTagsRequest(String hostName) {
            this.hostName = hostName;
        }

        public APIdeleteHostTagsRequest source(String source) {
            this.source = source;
            return this;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return TagsApi.this.deleteHostTagsWithHttpInfo(this.hostName, this.source);
        }
    }

    public class APIcreateHostTagsRequest {
        private String hostName;
        private HostTags body;
        private String source;

        private APIcreateHostTagsRequest(String hostName) {
            this.hostName = hostName;
        }

        public APIcreateHostTagsRequest body(HostTags body) {
            this.body = body;
            return this;
        }

        public APIcreateHostTagsRequest source(String source) {
            this.source = source;
            return this;
        }

        public HostTags execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<HostTags> executeWithHttpInfo() throws ApiException {
            return TagsApi.this.createHostTagsWithHttpInfo(this.hostName, this.body, this.source);
        }
    }
}

