/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.UsageAnalyzedLogsResponse;
import com.datadog.api.v1.client.model.UsageAttributionResponse;
import com.datadog.api.v1.client.model.UsageAttributionSort;
import com.datadog.api.v1.client.model.UsageBillableSummaryResponse;
import com.datadog.api.v1.client.model.UsageCustomReportsResponse;
import com.datadog.api.v1.client.model.UsageFargateResponse;
import com.datadog.api.v1.client.model.UsageHostsResponse;
import com.datadog.api.v1.client.model.UsageIncidentManagementResponse;
import com.datadog.api.v1.client.model.UsageIndexedSpansResponse;
import com.datadog.api.v1.client.model.UsageIngestedSpansResponse;
import com.datadog.api.v1.client.model.UsageIoTResponse;
import com.datadog.api.v1.client.model.UsageLambdaResponse;
import com.datadog.api.v1.client.model.UsageLogsByIndexResponse;
import com.datadog.api.v1.client.model.UsageLogsResponse;
import com.datadog.api.v1.client.model.UsageNetworkFlowsResponse;
import com.datadog.api.v1.client.model.UsageNetworkHostsResponse;
import com.datadog.api.v1.client.model.UsageProfilingResponse;
import com.datadog.api.v1.client.model.UsageRumSessionsResponse;
import com.datadog.api.v1.client.model.UsageSNMPResponse;
import com.datadog.api.v1.client.model.UsageSort;
import com.datadog.api.v1.client.model.UsageSortDirection;
import com.datadog.api.v1.client.model.UsageSpecifiedCustomReportsResponse;
import com.datadog.api.v1.client.model.UsageSummaryResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsAPIResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsBrowserResponse;
import com.datadog.api.v1.client.model.UsageSyntheticsResponse;
import com.datadog.api.v1.client.model.UsageTimeseriesResponse;
import com.datadog.api.v1.client.model.UsageTopAvgMetricsResponse;
import com.datadog.api.v1.client.model.UsageTraceResponse;
import com.datadog.api.v1.client.model.UsageTracingWithoutLimitsResponse;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class UsageMeteringApi {
    private ApiClient apiClient;

    public UsageMeteringApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UsageMeteringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<UsageCustomReportsResponse> getDailyCustomReportsWithHttpInfo(Long pageSize, Long pageNumber, UsageSortDirection sortDir, UsageSort sort) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/daily_custom_reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", (Object)sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarHeaderParams.put("DD-OPERATION-ID", "getDailyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageCustomReportsResponse> localVarReturnType = new GenericType<UsageCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getDailyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetDailyCustomReportsRequest getDailyCustomReports() throws ApiException {
        String operationId = "getDailyCustomReports";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIgetDailyCustomReportsRequest();
    }

    private ApiResponse<UsageIncidentManagementResponse> getIncidentManagementWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getIncidentManagement");
        }
        String localVarPath = "/api/v1/usage/incident-management";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIncidentManagement");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIncidentManagementResponse> localVarReturnType = new GenericType<UsageIncidentManagementResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getIncidentManagement", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetIncidentManagementRequest getIncidentManagement() throws ApiException {
        return new APIgetIncidentManagementRequest();
    }

    private ApiResponse<UsageIngestedSpansResponse> getIngestedSpansWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getIngestedSpans");
        }
        String localVarPath = "/api/v1/usage/ingested-spans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIngestedSpans");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIngestedSpansResponse> localVarReturnType = new GenericType<UsageIngestedSpansResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getIngestedSpans", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetIngestedSpansRequest getIngestedSpans() throws ApiException {
        return new APIgetIngestedSpansRequest();
    }

    private ApiResponse<UsageCustomReportsResponse> getMonthlyCustomReportsWithHttpInfo(Long pageSize, Long pageNumber, UsageSortDirection sortDir, UsageSort sort) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/monthly_custom_reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_dir", (Object)sortDir));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", (Object)sort));
        localVarHeaderParams.put("DD-OPERATION-ID", "getMonthlyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageCustomReportsResponse> localVarReturnType = new GenericType<UsageCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getMonthlyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetMonthlyCustomReportsRequest getMonthlyCustomReports() throws ApiException {
        String operationId = "getMonthlyCustomReports";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIgetMonthlyCustomReportsRequest();
    }

    private ApiResponse<UsageSpecifiedCustomReportsResponse> getSpecifiedDailyCustomReportsWithHttpInfo(String reportId) throws ApiException {
        Object localVarPostBody = null;
        if (reportId == null) {
            throw new ApiException(400, "Missing the required parameter 'reportId' when calling getSpecifiedDailyCustomReports");
        }
        String localVarPath = "/api/v1/daily_custom_reports/{report_id}".replaceAll("\\{report_id\\}", this.apiClient.escapeString(reportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSpecifiedDailyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSpecifiedCustomReportsResponse> localVarReturnType = new GenericType<UsageSpecifiedCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getSpecifiedDailyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetSpecifiedDailyCustomReportsRequest getSpecifiedDailyCustomReports(String reportId) throws ApiException {
        String operationId = "getSpecifiedDailyCustomReports";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIgetSpecifiedDailyCustomReportsRequest(reportId);
    }

    private ApiResponse<UsageSpecifiedCustomReportsResponse> getSpecifiedMonthlyCustomReportsWithHttpInfo(String reportId) throws ApiException {
        Object localVarPostBody = null;
        if (reportId == null) {
            throw new ApiException(400, "Missing the required parameter 'reportId' when calling getSpecifiedMonthlyCustomReports");
        }
        String localVarPath = "/api/v1/monthly_custom_reports/{report_id}".replaceAll("\\{report_id\\}", this.apiClient.escapeString(reportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "getSpecifiedMonthlyCustomReports");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSpecifiedCustomReportsResponse> localVarReturnType = new GenericType<UsageSpecifiedCustomReportsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getSpecifiedMonthlyCustomReports", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetSpecifiedMonthlyCustomReportsRequest getSpecifiedMonthlyCustomReports(String reportId) throws ApiException {
        String operationId = "getSpecifiedMonthlyCustomReports";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIgetSpecifiedMonthlyCustomReportsRequest(reportId);
    }

    private ApiResponse<UsageTracingWithoutLimitsResponse> getTracingWithoutLimitsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getTracingWithoutLimits");
        }
        String localVarPath = "/api/v1/usage/tracing-without-limits";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getTracingWithoutLimits");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTracingWithoutLimitsResponse> localVarReturnType = new GenericType<UsageTracingWithoutLimitsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getTracingWithoutLimits", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    @Deprecated
    public APIgetTracingWithoutLimitsRequest getTracingWithoutLimits() throws ApiException {
        return new APIgetTracingWithoutLimitsRequest();
    }

    private ApiResponse<UsageAnalyzedLogsResponse> getUsageAnalyzedLogsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageAnalyzedLogs");
        }
        String localVarPath = "/api/v1/usage/analyzed_logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageAnalyzedLogs");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageAnalyzedLogsResponse> localVarReturnType = new GenericType<UsageAnalyzedLogsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageAnalyzedLogs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageAnalyzedLogsRequest getUsageAnalyzedLogs() throws ApiException {
        return new APIgetUsageAnalyzedLogsRequest();
    }

    private ApiResponse<UsageAttributionResponse> getUsageAttributionWithHttpInfo(OffsetDateTime startMonth, String fields, OffsetDateTime endMonth, UsageSortDirection sortDirection, UsageAttributionSort sortName) throws ApiException {
        Object localVarPostBody = null;
        if (startMonth == null) {
            throw new ApiException(400, "Missing the required parameter 'startMonth' when calling getUsageAttribution");
        }
        if (fields == null) {
            throw new ApiException(400, "Missing the required parameter 'fields' when calling getUsageAttribution");
        }
        String localVarPath = "/api/v1/usage/attribution";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "fields", fields));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_direction", (Object)sortDirection));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort_name", (Object)sortName));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageAttribution");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageAttributionResponse> localVarReturnType = new GenericType<UsageAttributionResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageAttribution", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageAttributionRequest getUsageAttribution() throws ApiException {
        String operationId = "getUsageAttribution";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIgetUsageAttributionRequest();
    }

    private ApiResponse<UsageBillableSummaryResponse> getUsageBillableSummaryWithHttpInfo(OffsetDateTime month) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/usage/billable-summary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "month", month));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageBillableSummary");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageBillableSummaryResponse> localVarReturnType = new GenericType<UsageBillableSummaryResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageBillableSummary", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageBillableSummaryRequest getUsageBillableSummary() throws ApiException {
        return new APIgetUsageBillableSummaryRequest();
    }

    private ApiResponse<UsageFargateResponse> getUsageFargateWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageFargate");
        }
        String localVarPath = "/api/v1/usage/fargate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageFargate");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageFargateResponse> localVarReturnType = new GenericType<UsageFargateResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageFargate", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageFargateRequest getUsageFargate() throws ApiException {
        return new APIgetUsageFargateRequest();
    }

    private ApiResponse<UsageHostsResponse> getUsageHostsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageHosts");
        }
        String localVarPath = "/api/v1/usage/hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageHosts");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageHostsResponse> localVarReturnType = new GenericType<UsageHostsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageHosts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageHostsRequest getUsageHosts() throws ApiException {
        return new APIgetUsageHostsRequest();
    }

    private ApiResponse<UsageIndexedSpansResponse> getUsageIndexedSpansWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageIndexedSpans");
        }
        String localVarPath = "/api/v1/usage/indexed-spans";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageIndexedSpans");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIndexedSpansResponse> localVarReturnType = new GenericType<UsageIndexedSpansResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageIndexedSpans", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageIndexedSpansRequest getUsageIndexedSpans() throws ApiException {
        return new APIgetUsageIndexedSpansRequest();
    }

    private ApiResponse<UsageIoTResponse> getUsageInternetOfThingsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageInternetOfThings");
        }
        String localVarPath = "/api/v1/usage/iot";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageInternetOfThings");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageIoTResponse> localVarReturnType = new GenericType<UsageIoTResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageInternetOfThings", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageInternetOfThingsRequest getUsageInternetOfThings() throws ApiException {
        return new APIgetUsageInternetOfThingsRequest();
    }

    private ApiResponse<UsageLambdaResponse> getUsageLambdaWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLambda");
        }
        String localVarPath = "/api/v1/usage/aws_lambda";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLambda");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLambdaResponse> localVarReturnType = new GenericType<UsageLambdaResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLambda", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageLambdaRequest getUsageLambda() throws ApiException {
        return new APIgetUsageLambdaRequest();
    }

    private ApiResponse<UsageLogsResponse> getUsageLogsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLogs");
        }
        String localVarPath = "/api/v1/usage/logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLogs");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLogsResponse> localVarReturnType = new GenericType<UsageLogsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLogs", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageLogsRequest getUsageLogs() throws ApiException {
        return new APIgetUsageLogsRequest();
    }

    private ApiResponse<UsageLogsByIndexResponse> getUsageLogsByIndexWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr, List<String> indexName) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageLogsByIndex");
        }
        String localVarPath = "/api/v1/usage/logs_by_index";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "index_name", indexName));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageLogsByIndex");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageLogsByIndexResponse> localVarReturnType = new GenericType<UsageLogsByIndexResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageLogsByIndex", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageLogsByIndexRequest getUsageLogsByIndex() throws ApiException {
        return new APIgetUsageLogsByIndexRequest();
    }

    private ApiResponse<UsageNetworkFlowsResponse> getUsageNetworkFlowsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageNetworkFlows");
        }
        String localVarPath = "/api/v1/usage/network_flows";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageNetworkFlows");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageNetworkFlowsResponse> localVarReturnType = new GenericType<UsageNetworkFlowsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageNetworkFlows", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageNetworkFlowsRequest getUsageNetworkFlows() throws ApiException {
        return new APIgetUsageNetworkFlowsRequest();
    }

    private ApiResponse<UsageNetworkHostsResponse> getUsageNetworkHostsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageNetworkHosts");
        }
        String localVarPath = "/api/v1/usage/network_hosts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageNetworkHosts");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageNetworkHostsResponse> localVarReturnType = new GenericType<UsageNetworkHostsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageNetworkHosts", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageNetworkHostsRequest getUsageNetworkHosts() throws ApiException {
        return new APIgetUsageNetworkHostsRequest();
    }

    private ApiResponse<UsageProfilingResponse> getUsageProfilingWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageProfiling");
        }
        String localVarPath = "/api/v1/usage/profiling";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageProfiling");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageProfilingResponse> localVarReturnType = new GenericType<UsageProfilingResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageProfiling", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageProfilingRequest getUsageProfiling() throws ApiException {
        return new APIgetUsageProfilingRequest();
    }

    private ApiResponse<UsageRumSessionsResponse> getUsageRumSessionsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr, String type) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageRumSessions");
        }
        String localVarPath = "/api/v1/usage/rum_sessions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "type", type));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageRumSessions");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageRumSessionsResponse> localVarReturnType = new GenericType<UsageRumSessionsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageRumSessions", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageRumSessionsRequest getUsageRumSessions() throws ApiException {
        return new APIgetUsageRumSessionsRequest();
    }

    private ApiResponse<UsageSNMPResponse> getUsageSNMPWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSNMP");
        }
        String localVarPath = "/api/v1/usage/snmp";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSNMP");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSNMPResponse> localVarReturnType = new GenericType<UsageSNMPResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSNMP", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageSNMPRequest getUsageSNMP() throws ApiException {
        return new APIgetUsageSNMPRequest();
    }

    private ApiResponse<UsageSummaryResponse> getUsageSummaryWithHttpInfo(OffsetDateTime startMonth, OffsetDateTime endMonth, Boolean includeOrgDetails) throws ApiException {
        Object localVarPostBody = null;
        if (startMonth == null) {
            throw new ApiException(400, "Missing the required parameter 'startMonth' when calling getUsageSummary");
        }
        String localVarPath = "/api/v1/usage/summary";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_month", startMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_month", endMonth));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include_org_details", includeOrgDetails));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSummary");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSummaryResponse> localVarReturnType = new GenericType<UsageSummaryResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSummary", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageSummaryRequest getUsageSummary() throws ApiException {
        return new APIgetUsageSummaryRequest();
    }

    private ApiResponse<UsageSyntheticsResponse> getUsageSyntheticsWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSynthetics");
        }
        String localVarPath = "/api/v1/usage/synthetics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSynthetics");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsResponse> localVarReturnType = new GenericType<UsageSyntheticsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSynthetics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    @Deprecated
    public APIgetUsageSyntheticsRequest getUsageSynthetics() throws ApiException {
        return new APIgetUsageSyntheticsRequest();
    }

    private ApiResponse<UsageSyntheticsAPIResponse> getUsageSyntheticsAPIWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSyntheticsAPI");
        }
        String localVarPath = "/api/v1/usage/synthetics_api";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSyntheticsAPI");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsAPIResponse> localVarReturnType = new GenericType<UsageSyntheticsAPIResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSyntheticsAPI", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageSyntheticsAPIRequest getUsageSyntheticsAPI() throws ApiException {
        return new APIgetUsageSyntheticsAPIRequest();
    }

    private ApiResponse<UsageSyntheticsBrowserResponse> getUsageSyntheticsBrowserWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageSyntheticsBrowser");
        }
        String localVarPath = "/api/v1/usage/synthetics_browser";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageSyntheticsBrowser");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageSyntheticsBrowserResponse> localVarReturnType = new GenericType<UsageSyntheticsBrowserResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageSyntheticsBrowser", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageSyntheticsBrowserRequest getUsageSyntheticsBrowser() throws ApiException {
        return new APIgetUsageSyntheticsBrowserRequest();
    }

    private ApiResponse<UsageTimeseriesResponse> getUsageTimeseriesWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageTimeseries");
        }
        String localVarPath = "/api/v1/usage/timeseries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageTimeseries");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTimeseriesResponse> localVarReturnType = new GenericType<UsageTimeseriesResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageTimeseries", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageTimeseriesRequest getUsageTimeseries() throws ApiException {
        return new APIgetUsageTimeseriesRequest();
    }

    private ApiResponse<UsageTopAvgMetricsResponse> getUsageTopAvgMetricsWithHttpInfo(OffsetDateTime month, List<String> names, Integer limit) throws ApiException {
        Object localVarPostBody = null;
        if (month == null) {
            throw new ApiException(400, "Missing the required parameter 'month' when calling getUsageTopAvgMetrics");
        }
        String localVarPath = "/api/v1/usage/top_avg_metrics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "month", month));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "names", names));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageTopAvgMetrics");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTopAvgMetricsResponse> localVarReturnType = new GenericType<UsageTopAvgMetricsResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageTopAvgMetrics", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetUsageTopAvgMetricsRequest getUsageTopAvgMetrics() throws ApiException {
        return new APIgetUsageTopAvgMetricsRequest();
    }

    private ApiResponse<UsageTraceResponse> getUsageTraceWithHttpInfo(OffsetDateTime startHr, OffsetDateTime endHr) throws ApiException {
        Object localVarPostBody = null;
        if (startHr == null) {
            throw new ApiException(400, "Missing the required parameter 'startHr' when calling getUsageTrace");
        }
        String localVarPath = "/api/v1/usage/traces";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "start_hr", startHr));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "end_hr", endHr));
        localVarHeaderParams.put("DD-OPERATION-ID", "getUsageTrace");
        String[] localVarAccepts = new String[]{"application/json;datetime-format=rfc3339"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<UsageTraceResponse> localVarReturnType = new GenericType<UsageTraceResponse>(){};
        return this.apiClient.invokeAPI("UsageMeteringApi.getUsageTrace", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    @Deprecated
    public APIgetUsageTraceRequest getUsageTrace() throws ApiException {
        return new APIgetUsageTraceRequest();
    }

    public class APIgetUsageTraceRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageTraceRequest() {
        }

        public APIgetUsageTraceRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageTraceRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        @Deprecated
        public UsageTraceResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        @Deprecated
        public ApiResponse<UsageTraceResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageTraceWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageTopAvgMetricsRequest {
        private OffsetDateTime month;
        private List<String> names;
        private Integer limit;

        private APIgetUsageTopAvgMetricsRequest() {
        }

        public APIgetUsageTopAvgMetricsRequest month(OffsetDateTime month) {
            this.month = month;
            return this;
        }

        public APIgetUsageTopAvgMetricsRequest names(List<String> names) {
            this.names = names;
            return this;
        }

        public APIgetUsageTopAvgMetricsRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public UsageTopAvgMetricsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageTopAvgMetricsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageTopAvgMetricsWithHttpInfo(this.month, this.names, this.limit);
        }
    }

    public class APIgetUsageTimeseriesRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageTimeseriesRequest() {
        }

        public APIgetUsageTimeseriesRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageTimeseriesRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageTimeseriesResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageTimeseriesResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageTimeseriesWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageSyntheticsBrowserRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageSyntheticsBrowserRequest() {
        }

        public APIgetUsageSyntheticsBrowserRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageSyntheticsBrowserRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageSyntheticsBrowserResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageSyntheticsBrowserResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageSyntheticsBrowserWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageSyntheticsAPIRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageSyntheticsAPIRequest() {
        }

        public APIgetUsageSyntheticsAPIRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageSyntheticsAPIRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageSyntheticsAPIResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageSyntheticsAPIResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageSyntheticsAPIWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageSyntheticsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageSyntheticsRequest() {
        }

        public APIgetUsageSyntheticsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageSyntheticsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        @Deprecated
        public UsageSyntheticsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        @Deprecated
        public ApiResponse<UsageSyntheticsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageSyntheticsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageSummaryRequest {
        private OffsetDateTime startMonth;
        private OffsetDateTime endMonth;
        private Boolean includeOrgDetails;

        private APIgetUsageSummaryRequest() {
        }

        public APIgetUsageSummaryRequest startMonth(OffsetDateTime startMonth) {
            this.startMonth = startMonth;
            return this;
        }

        public APIgetUsageSummaryRequest endMonth(OffsetDateTime endMonth) {
            this.endMonth = endMonth;
            return this;
        }

        public APIgetUsageSummaryRequest includeOrgDetails(Boolean includeOrgDetails) {
            this.includeOrgDetails = includeOrgDetails;
            return this;
        }

        public UsageSummaryResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageSummaryResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageSummaryWithHttpInfo(this.startMonth, this.endMonth, this.includeOrgDetails);
        }
    }

    public class APIgetUsageSNMPRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageSNMPRequest() {
        }

        public APIgetUsageSNMPRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageSNMPRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageSNMPResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageSNMPResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageSNMPWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageRumSessionsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;
        private String type;

        private APIgetUsageRumSessionsRequest() {
        }

        public APIgetUsageRumSessionsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageRumSessionsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public APIgetUsageRumSessionsRequest type(String type) {
            this.type = type;
            return this;
        }

        public UsageRumSessionsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageRumSessionsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageRumSessionsWithHttpInfo(this.startHr, this.endHr, this.type);
        }
    }

    public class APIgetUsageProfilingRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageProfilingRequest() {
        }

        public APIgetUsageProfilingRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageProfilingRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageProfilingResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageProfilingResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageProfilingWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageNetworkHostsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageNetworkHostsRequest() {
        }

        public APIgetUsageNetworkHostsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageNetworkHostsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageNetworkHostsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageNetworkHostsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageNetworkHostsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageNetworkFlowsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageNetworkFlowsRequest() {
        }

        public APIgetUsageNetworkFlowsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageNetworkFlowsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageNetworkFlowsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageNetworkFlowsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageNetworkFlowsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageLogsByIndexRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;
        private List<String> indexName;

        private APIgetUsageLogsByIndexRequest() {
        }

        public APIgetUsageLogsByIndexRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageLogsByIndexRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public APIgetUsageLogsByIndexRequest indexName(List<String> indexName) {
            this.indexName = indexName;
            return this;
        }

        public UsageLogsByIndexResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageLogsByIndexResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageLogsByIndexWithHttpInfo(this.startHr, this.endHr, this.indexName);
        }
    }

    public class APIgetUsageLogsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageLogsRequest() {
        }

        public APIgetUsageLogsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageLogsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageLogsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageLogsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageLogsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageLambdaRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageLambdaRequest() {
        }

        public APIgetUsageLambdaRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageLambdaRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageLambdaResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageLambdaResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageLambdaWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageInternetOfThingsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageInternetOfThingsRequest() {
        }

        public APIgetUsageInternetOfThingsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageInternetOfThingsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageIoTResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageIoTResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageInternetOfThingsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageIndexedSpansRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageIndexedSpansRequest() {
        }

        public APIgetUsageIndexedSpansRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageIndexedSpansRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageIndexedSpansResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageIndexedSpansResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageIndexedSpansWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageHostsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageHostsRequest() {
        }

        public APIgetUsageHostsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageHostsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageHostsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageHostsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageHostsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageFargateRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageFargateRequest() {
        }

        public APIgetUsageFargateRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageFargateRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageFargateResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageFargateResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageFargateWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetUsageBillableSummaryRequest {
        private OffsetDateTime month;

        private APIgetUsageBillableSummaryRequest() {
        }

        public APIgetUsageBillableSummaryRequest month(OffsetDateTime month) {
            this.month = month;
            return this;
        }

        public UsageBillableSummaryResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageBillableSummaryResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageBillableSummaryWithHttpInfo(this.month);
        }
    }

    public class APIgetUsageAttributionRequest {
        private OffsetDateTime startMonth;
        private String fields;
        private OffsetDateTime endMonth;
        private UsageSortDirection sortDirection;
        private UsageAttributionSort sortName;

        private APIgetUsageAttributionRequest() {
        }

        public APIgetUsageAttributionRequest startMonth(OffsetDateTime startMonth) {
            this.startMonth = startMonth;
            return this;
        }

        public APIgetUsageAttributionRequest fields(String fields) {
            this.fields = fields;
            return this;
        }

        public APIgetUsageAttributionRequest endMonth(OffsetDateTime endMonth) {
            this.endMonth = endMonth;
            return this;
        }

        public APIgetUsageAttributionRequest sortDirection(UsageSortDirection sortDirection) {
            this.sortDirection = sortDirection;
            return this;
        }

        public APIgetUsageAttributionRequest sortName(UsageAttributionSort sortName) {
            this.sortName = sortName;
            return this;
        }

        public UsageAttributionResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageAttributionResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageAttributionWithHttpInfo(this.startMonth, this.fields, this.endMonth, this.sortDirection, this.sortName);
        }
    }

    public class APIgetUsageAnalyzedLogsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetUsageAnalyzedLogsRequest() {
        }

        public APIgetUsageAnalyzedLogsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetUsageAnalyzedLogsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageAnalyzedLogsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageAnalyzedLogsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getUsageAnalyzedLogsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetTracingWithoutLimitsRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetTracingWithoutLimitsRequest() {
        }

        public APIgetTracingWithoutLimitsRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetTracingWithoutLimitsRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        @Deprecated
        public UsageTracingWithoutLimitsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        @Deprecated
        public ApiResponse<UsageTracingWithoutLimitsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getTracingWithoutLimitsWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetSpecifiedMonthlyCustomReportsRequest {
        private String reportId;

        private APIgetSpecifiedMonthlyCustomReportsRequest(String reportId) {
            this.reportId = reportId;
        }

        public UsageSpecifiedCustomReportsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageSpecifiedCustomReportsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getSpecifiedMonthlyCustomReportsWithHttpInfo(this.reportId);
        }
    }

    public class APIgetSpecifiedDailyCustomReportsRequest {
        private String reportId;

        private APIgetSpecifiedDailyCustomReportsRequest(String reportId) {
            this.reportId = reportId;
        }

        public UsageSpecifiedCustomReportsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageSpecifiedCustomReportsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getSpecifiedDailyCustomReportsWithHttpInfo(this.reportId);
        }
    }

    public class APIgetMonthlyCustomReportsRequest {
        private Long pageSize;
        private Long pageNumber;
        private UsageSortDirection sortDir;
        private UsageSort sort;

        private APIgetMonthlyCustomReportsRequest() {
        }

        public APIgetMonthlyCustomReportsRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIgetMonthlyCustomReportsRequest pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public APIgetMonthlyCustomReportsRequest sortDir(UsageSortDirection sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public APIgetMonthlyCustomReportsRequest sort(UsageSort sort) {
            this.sort = sort;
            return this;
        }

        public UsageCustomReportsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageCustomReportsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getMonthlyCustomReportsWithHttpInfo(this.pageSize, this.pageNumber, this.sortDir, this.sort);
        }
    }

    public class APIgetIngestedSpansRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetIngestedSpansRequest() {
        }

        public APIgetIngestedSpansRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetIngestedSpansRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageIngestedSpansResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageIngestedSpansResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getIngestedSpansWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetIncidentManagementRequest {
        private OffsetDateTime startHr;
        private OffsetDateTime endHr;

        private APIgetIncidentManagementRequest() {
        }

        public APIgetIncidentManagementRequest startHr(OffsetDateTime startHr) {
            this.startHr = startHr;
            return this;
        }

        public APIgetIncidentManagementRequest endHr(OffsetDateTime endHr) {
            this.endHr = endHr;
            return this;
        }

        public UsageIncidentManagementResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageIncidentManagementResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getIncidentManagementWithHttpInfo(this.startHr, this.endHr);
        }
    }

    public class APIgetDailyCustomReportsRequest {
        private Long pageSize;
        private Long pageNumber;
        private UsageSortDirection sortDir;
        private UsageSort sort;

        private APIgetDailyCustomReportsRequest() {
        }

        public APIgetDailyCustomReportsRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIgetDailyCustomReportsRequest pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public APIgetDailyCustomReportsRequest sortDir(UsageSortDirection sortDir) {
            this.sortDir = sortDir;
            return this;
        }

        public APIgetDailyCustomReportsRequest sort(UsageSort sort) {
            this.sort = sort;
            return this;
        }

        public UsageCustomReportsResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<UsageCustomReportsResponse> executeWithHttpInfo() throws ApiException {
            return UsageMeteringApi.this.getDailyCustomReportsWithHttpInfo(this.pageSize, this.pageNumber, this.sortDir, this.sort);
        }
    }
}

