/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An application key with its associated metadata.")
@JsonPropertyOrder(value={"hash", "name", "owner"})
public class ApplicationKey {
    public static final String JSON_PROPERTY_HASH = "hash";
    private String hash;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER = "owner";
    private String owner;

    @Nullable
    @ApiModelProperty(example="1234512345123459cda4eb9ced49a3d84fd0138c", value="Hash of an application key.")
    @JsonProperty(value="hash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHash() {
        return this.hash;
    }

    public ApplicationKey name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="example user", value="Name of an application key.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    @ApiModelProperty(example="example.com", value="Owner of an application key.")
    @JsonProperty(value="owner")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOwner() {
        return this.owner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationKey applicationKey = (ApplicationKey)o;
        return Objects.equals(this.hash, applicationKey.hash) && Objects.equals(this.name, applicationKey.name) && Objects.equals(this.owner, applicationKey.owner);
    }

    public int hashCode() {
        return Objects.hash(this.hash, this.name, this.owner);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationKey {\n");
        sb.append("    hash: ").append(this.toIndentedString(this.hash)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

