/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.LogsDateRemapperType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="As Datadog receives logs, it timestamps them using the value(s) from any of these default attributes.    - `timestamp`   - `date`   - `_timestamp`   - `Timestamp`   - `eventTime`   - `published_date`    If your logs put their dates in an attribute not in this list,   use the log date Remapper Processor to define their date attribute as the official log timestamp.   The recognized date formats are ISO8601, UNIX (the milliseconds EPOCH format), and RFC3164.    **Note:** If your logs don\u2019t contain any of the default attributes   and you haven\u2019t defined your own date attribute, Datadog timestamps   the logs with the date it received them.    If multiple log date remapper processors can be applied to a given log,   only the first one (according to the pipelines order) is taken into account.")
@JsonPropertyOrder(value={"is_enabled", "name", "sources", "type"})
public class LogsDateRemapper {
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = new ArrayList<String>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsDateRemapperType type = LogsDateRemapperType.DATE_REMAPPER;

    public LogsDateRemapper isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the processor is enabled.")
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public LogsDateRemapper name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the processor.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsDateRemapper sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public LogsDateRemapper addSourcesItem(String sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @ApiModelProperty(example="[\"web\",\"gateway\"]", required=true, value="Array of source attributes.")
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public LogsDateRemapper type(LogsDateRemapperType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsDateRemapperType getType() {
        return this.type;
    }

    public void setType(LogsDateRemapperType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsDateRemapper logsDateRemapper = (LogsDateRemapper)o;
        return Objects.equals(this.isEnabled, logsDateRemapper.isEnabled) && Objects.equals(this.name, logsDateRemapper.name) && Objects.equals(this.sources, logsDateRemapper.sources) && Objects.equals((Object)this.type, (Object)logsDateRemapper.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isEnabled, this.name, this.sources, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsDateRemapper {\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

