/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.AccessRole;
import com.datadog.api.v1.client.model.OrganizationSettingsSaml;
import com.datadog.api.v1.client.model.OrganizationSettingsSamlAutocreateUsersDomains;
import com.datadog.api.v1.client.model.OrganizationSettingsSamlIdpInitiatedLogin;
import com.datadog.api.v1.client.model.OrganizationSettingsSamlStrictMode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A JSON array of settings.")
@JsonPropertyOrder(value={"private_widget_share", "saml", "saml_autocreate_access_role", "saml_autocreate_users_domains", "saml_can_be_enabled", "saml_idp_endpoint", "saml_idp_initiated_login", "saml_idp_metadata_uploaded", "saml_login_url", "saml_strict_mode"})
public class OrganizationSettings {
    public static final String JSON_PROPERTY_PRIVATE_WIDGET_SHARE = "private_widget_share";
    private Boolean privateWidgetShare;
    public static final String JSON_PROPERTY_SAML = "saml";
    private OrganizationSettingsSaml saml;
    public static final String JSON_PROPERTY_SAML_AUTOCREATE_ACCESS_ROLE = "saml_autocreate_access_role";
    private AccessRole samlAutocreateAccessRole = AccessRole.STANDARD;
    public static final String JSON_PROPERTY_SAML_AUTOCREATE_USERS_DOMAINS = "saml_autocreate_users_domains";
    private OrganizationSettingsSamlAutocreateUsersDomains samlAutocreateUsersDomains;
    public static final String JSON_PROPERTY_SAML_CAN_BE_ENABLED = "saml_can_be_enabled";
    private Boolean samlCanBeEnabled;
    public static final String JSON_PROPERTY_SAML_IDP_ENDPOINT = "saml_idp_endpoint";
    private String samlIdpEndpoint;
    public static final String JSON_PROPERTY_SAML_IDP_INITIATED_LOGIN = "saml_idp_initiated_login";
    private OrganizationSettingsSamlIdpInitiatedLogin samlIdpInitiatedLogin;
    public static final String JSON_PROPERTY_SAML_IDP_METADATA_UPLOADED = "saml_idp_metadata_uploaded";
    private Boolean samlIdpMetadataUploaded;
    public static final String JSON_PROPERTY_SAML_LOGIN_URL = "saml_login_url";
    private String samlLoginUrl;
    public static final String JSON_PROPERTY_SAML_STRICT_MODE = "saml_strict_mode";
    private OrganizationSettingsSamlStrictMode samlStrictMode;

    public OrganizationSettings privateWidgetShare(Boolean privateWidgetShare) {
        this.privateWidgetShare = privateWidgetShare;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether or not the organization users can share widgets outside of Datadog.")
    @JsonProperty(value="private_widget_share")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPrivateWidgetShare() {
        return this.privateWidgetShare;
    }

    public void setPrivateWidgetShare(Boolean privateWidgetShare) {
        this.privateWidgetShare = privateWidgetShare;
    }

    public OrganizationSettings saml(OrganizationSettingsSaml saml) {
        this.saml = saml;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="saml")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OrganizationSettingsSaml getSaml() {
        return this.saml;
    }

    public void setSaml(OrganizationSettingsSaml saml) {
        this.saml = saml;
    }

    public OrganizationSettings samlAutocreateAccessRole(AccessRole samlAutocreateAccessRole) {
        this.samlAutocreateAccessRole = samlAutocreateAccessRole;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="saml_autocreate_access_role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccessRole getSamlAutocreateAccessRole() {
        return this.samlAutocreateAccessRole;
    }

    public void setSamlAutocreateAccessRole(AccessRole samlAutocreateAccessRole) {
        this.samlAutocreateAccessRole = samlAutocreateAccessRole;
    }

    public OrganizationSettings samlAutocreateUsersDomains(OrganizationSettingsSamlAutocreateUsersDomains samlAutocreateUsersDomains) {
        this.samlAutocreateUsersDomains = samlAutocreateUsersDomains;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="saml_autocreate_users_domains")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OrganizationSettingsSamlAutocreateUsersDomains getSamlAutocreateUsersDomains() {
        return this.samlAutocreateUsersDomains;
    }

    public void setSamlAutocreateUsersDomains(OrganizationSettingsSamlAutocreateUsersDomains samlAutocreateUsersDomains) {
        this.samlAutocreateUsersDomains = samlAutocreateUsersDomains;
    }

    public OrganizationSettings samlCanBeEnabled(Boolean samlCanBeEnabled) {
        this.samlCanBeEnabled = samlCanBeEnabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether or not SAML can be enabled for this organization.")
    @JsonProperty(value="saml_can_be_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSamlCanBeEnabled() {
        return this.samlCanBeEnabled;
    }

    public void setSamlCanBeEnabled(Boolean samlCanBeEnabled) {
        this.samlCanBeEnabled = samlCanBeEnabled;
    }

    public OrganizationSettings samlIdpEndpoint(String samlIdpEndpoint) {
        this.samlIdpEndpoint = samlIdpEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://my.saml.endpoint", value="Identity provider endpoint for SAML authentication.")
    @JsonProperty(value="saml_idp_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSamlIdpEndpoint() {
        return this.samlIdpEndpoint;
    }

    public void setSamlIdpEndpoint(String samlIdpEndpoint) {
        this.samlIdpEndpoint = samlIdpEndpoint;
    }

    public OrganizationSettings samlIdpInitiatedLogin(OrganizationSettingsSamlIdpInitiatedLogin samlIdpInitiatedLogin) {
        this.samlIdpInitiatedLogin = samlIdpInitiatedLogin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="saml_idp_initiated_login")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OrganizationSettingsSamlIdpInitiatedLogin getSamlIdpInitiatedLogin() {
        return this.samlIdpInitiatedLogin;
    }

    public void setSamlIdpInitiatedLogin(OrganizationSettingsSamlIdpInitiatedLogin samlIdpInitiatedLogin) {
        this.samlIdpInitiatedLogin = samlIdpInitiatedLogin;
    }

    public OrganizationSettings samlIdpMetadataUploaded(Boolean samlIdpMetadataUploaded) {
        this.samlIdpMetadataUploaded = samlIdpMetadataUploaded;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Whether or not a SAML identity provider metadata file was provided to the Datadog organization.")
    @JsonProperty(value="saml_idp_metadata_uploaded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSamlIdpMetadataUploaded() {
        return this.samlIdpMetadataUploaded;
    }

    public void setSamlIdpMetadataUploaded(Boolean samlIdpMetadataUploaded) {
        this.samlIdpMetadataUploaded = samlIdpMetadataUploaded;
    }

    public OrganizationSettings samlLoginUrl(String samlLoginUrl) {
        this.samlLoginUrl = samlLoginUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://my.saml.login.url", value="URL for SAML logging.")
    @JsonProperty(value="saml_login_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSamlLoginUrl() {
        return this.samlLoginUrl;
    }

    public void setSamlLoginUrl(String samlLoginUrl) {
        this.samlLoginUrl = samlLoginUrl;
    }

    public OrganizationSettings samlStrictMode(OrganizationSettingsSamlStrictMode samlStrictMode) {
        this.samlStrictMode = samlStrictMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="saml_strict_mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OrganizationSettingsSamlStrictMode getSamlStrictMode() {
        return this.samlStrictMode;
    }

    public void setSamlStrictMode(OrganizationSettingsSamlStrictMode samlStrictMode) {
        this.samlStrictMode = samlStrictMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationSettings organizationSettings = (OrganizationSettings)o;
        return Objects.equals(this.privateWidgetShare, organizationSettings.privateWidgetShare) && Objects.equals(this.saml, organizationSettings.saml) && Objects.equals((Object)this.samlAutocreateAccessRole, (Object)organizationSettings.samlAutocreateAccessRole) && Objects.equals(this.samlAutocreateUsersDomains, organizationSettings.samlAutocreateUsersDomains) && Objects.equals(this.samlCanBeEnabled, organizationSettings.samlCanBeEnabled) && Objects.equals(this.samlIdpEndpoint, organizationSettings.samlIdpEndpoint) && Objects.equals(this.samlIdpInitiatedLogin, organizationSettings.samlIdpInitiatedLogin) && Objects.equals(this.samlIdpMetadataUploaded, organizationSettings.samlIdpMetadataUploaded) && Objects.equals(this.samlLoginUrl, organizationSettings.samlLoginUrl) && Objects.equals(this.samlStrictMode, organizationSettings.samlStrictMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.privateWidgetShare, this.saml, this.samlAutocreateAccessRole, this.samlAutocreateUsersDomains, this.samlCanBeEnabled, this.samlIdpEndpoint, this.samlIdpInitiatedLogin, this.samlIdpMetadataUploaded, this.samlLoginUrl, this.samlStrictMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationSettings {\n");
        sb.append("    privateWidgetShare: ").append(this.toIndentedString(this.privateWidgetShare)).append("\n");
        sb.append("    saml: ").append(this.toIndentedString(this.saml)).append("\n");
        sb.append("    samlAutocreateAccessRole: ").append(this.toIndentedString((Object)this.samlAutocreateAccessRole)).append("\n");
        sb.append("    samlAutocreateUsersDomains: ").append(this.toIndentedString(this.samlAutocreateUsersDomains)).append("\n");
        sb.append("    samlCanBeEnabled: ").append(this.toIndentedString(this.samlCanBeEnabled)).append("\n");
        sb.append("    samlIdpEndpoint: ").append(this.toIndentedString(this.samlIdpEndpoint)).append("\n");
        sb.append("    samlIdpInitiatedLogin: ").append(this.toIndentedString(this.samlIdpInitiatedLogin)).append("\n");
        sb.append("    samlIdpMetadataUploaded: ").append(this.toIndentedString(this.samlIdpMetadataUploaded)).append("\n");
        sb.append("    samlLoginUrl: ").append(this.toIndentedString(this.samlLoginUrl)).append("\n");
        sb.append("    samlStrictMode: ").append(this.toIndentedString(this.samlStrictMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

