/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.Creator;
import com.datadog.api.v1.client.model.SLOCorrectionCategory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The attribute object associated with the SLO correction")
@JsonPropertyOrder(value={"category", "creator", "description", "end", "slo_id", "start", "timezone"})
public class SLOCorrectionResponseAttributes {
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private SLOCorrectionCategory category;
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private Creator creator;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_END = "end";
    private Long end;
    public static final String JSON_PROPERTY_SLO_ID = "slo_id";
    private String sloId;
    public static final String JSON_PROPERTY_START = "start";
    private Long start;
    public static final String JSON_PROPERTY_TIMEZONE = "timezone";
    private String timezone;

    public SLOCorrectionResponseAttributes category(SLOCorrectionCategory category) {
        this.category = category;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SLOCorrectionCategory getCategory() {
        return this.category;
    }

    public void setCategory(SLOCorrectionCategory category) {
        this.category = category;
    }

    public SLOCorrectionResponseAttributes creator(Creator creator) {
        this.creator = creator;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Creator getCreator() {
        return this.creator;
    }

    public void setCreator(Creator creator) {
        this.creator = creator;
    }

    public SLOCorrectionResponseAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the correction being made.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SLOCorrectionResponseAttributes end(Long end) {
        this.end = end;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Ending time of the correction in epoch seconds")
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    public SLOCorrectionResponseAttributes sloId(String sloId) {
        this.sloId = sloId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the SLO that this correction will be applied to")
    @JsonProperty(value="slo_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSloId() {
        return this.sloId;
    }

    public void setSloId(String sloId) {
        this.sloId = sloId;
    }

    public SLOCorrectionResponseAttributes start(Long start) {
        this.start = start;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Starting time of the correction in epoch seconds")
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public SLOCorrectionResponseAttributes timezone(String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The timezone to display in the UI for the correction times (defaults to \"UTC\")")
    @JsonProperty(value="timezone")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOCorrectionResponseAttributes slOCorrectionResponseAttributes = (SLOCorrectionResponseAttributes)o;
        return Objects.equals((Object)this.category, (Object)slOCorrectionResponseAttributes.category) && Objects.equals(this.creator, slOCorrectionResponseAttributes.creator) && Objects.equals(this.description, slOCorrectionResponseAttributes.description) && Objects.equals(this.end, slOCorrectionResponseAttributes.end) && Objects.equals(this.sloId, slOCorrectionResponseAttributes.sloId) && Objects.equals(this.start, slOCorrectionResponseAttributes.start) && Objects.equals(this.timezone, slOCorrectionResponseAttributes.timezone);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.category, this.creator, this.description, this.end, this.sloId, this.start, this.timezone});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOCorrectionResponseAttributes {\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    sloId: ").append(this.toIndentedString(this.sloId)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    timezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

