/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object that holds an SLI value and its associated data. It can represent an SLO's overall SLI value or the SLI value for a specific monitor (in multi-monitor SLOs) or group (in grouped SLOs). The uptime history is included for monitor SLOs.")
@JsonPropertyOrder(value={"history", "name", "precision", "preview", "sli_value", "span_precision", "uptime"})
public class SLOHistorySLIData {
    public static final String JSON_PROPERTY_HISTORY = "history";
    private List<List<Double>> history = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRECISION = "precision";
    private Map<String, Double> precision = null;
    public static final String JSON_PROPERTY_PREVIEW = "preview";
    private Boolean preview;
    public static final String JSON_PROPERTY_SLI_VALUE = "sli_value";
    private Double sliValue;
    public static final String JSON_PROPERTY_SPAN_PRECISION = "span_precision";
    private Double spanPrecision;
    public static final String JSON_PROPERTY_UPTIME = "uptime";
    private Double uptime;

    public SLOHistorySLIData history(List<List<Double>> history) {
        this.history = history;
        return this;
    }

    public SLOHistorySLIData addHistoryItem(List<Double> historyItem) {
        if (this.history == null) {
            this.history = new ArrayList<List<Double>>();
        }
        this.history.add(historyItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For `monitor` based SLOs, this includes the aggregated history uptime time series.")
    @JsonProperty(value="history")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<List<Double>> getHistory() {
        return this.history;
    }

    public void setHistory(List<List<Double>> history) {
        this.history = history;
    }

    public SLOHistorySLIData name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For groups in a grouped SLO this is the group name. For monitors in a multi-monitor SLO this is the monitor name.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SLOHistorySLIData precision(Map<String, Double> precision) {
        this.precision = precision;
        return this;
    }

    public SLOHistorySLIData putPrecisionItem(String key, Double precisionItem) {
        if (this.precision == null) {
            this.precision = new HashMap<String, Double>();
        }
        this.precision.put(key, precisionItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A mapping of threshold `timeframe` to number of accurate decimals, regardless of the from && to timestamp.")
    @JsonProperty(value="precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Double> getPrecision() {
        return this.precision;
    }

    public void setPrecision(Map<String, Double> precision) {
        this.precision = precision;
    }

    public SLOHistorySLIData preview(Boolean preview) {
        this.preview = preview;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="For `monitor` based SLOs when `true` this indicates that a replay is in progress to give an accurate uptime calculation.")
    @JsonProperty(value="preview")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPreview() {
        return this.preview;
    }

    public void setPreview(Boolean preview) {
        this.preview = preview;
    }

    public SLOHistorySLIData sliValue(Double sliValue) {
        this.sliValue = sliValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="99.99", value="The current SLI value of the SLO over the history window.")
    @JsonProperty(value="sli_value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSliValue() {
        return this.sliValue;
    }

    public void setSliValue(Double sliValue) {
        this.sliValue = sliValue;
    }

    public SLOHistorySLIData spanPrecision(Double spanPrecision) {
        this.spanPrecision = spanPrecision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of decimal places the SLI value is accurate to for the given from `&&` to timestamp.")
    @JsonProperty(value="span_precision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getSpanPrecision() {
        return this.spanPrecision;
    }

    public void setSpanPrecision(Double spanPrecision) {
        this.spanPrecision = spanPrecision;
    }

    public SLOHistorySLIData uptime(Double uptime) {
        this.uptime = uptime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Deprecated. Use `sli_value` instead.")
    @JsonProperty(value="uptime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUptime() {
        return this.uptime;
    }

    public void setUptime(Double uptime) {
        this.uptime = uptime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOHistorySLIData slOHistorySLIData = (SLOHistorySLIData)o;
        return Objects.equals(this.history, slOHistorySLIData.history) && Objects.equals(this.name, slOHistorySLIData.name) && Objects.equals(this.precision, slOHistorySLIData.precision) && Objects.equals(this.preview, slOHistorySLIData.preview) && Objects.equals(this.sliValue, slOHistorySLIData.sliValue) && Objects.equals(this.spanPrecision, slOHistorySLIData.spanPrecision) && Objects.equals(this.uptime, slOHistorySLIData.uptime);
    }

    public int hashCode() {
        return Objects.hash(this.history, this.name, this.precision, this.preview, this.sliValue, this.spanPrecision, this.uptime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOHistorySLIData {\n");
        sb.append("    history: ").append(this.toIndentedString(this.history)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    preview: ").append(this.toIndentedString(this.preview)).append("\n");
        sb.append("    sliValue: ").append(this.toIndentedString(this.sliValue)).append("\n");
        sb.append("    spanPrecision: ").append(this.toIndentedString(this.spanPrecision)).append("\n");
        sb.append("    uptime: ").append(this.toIndentedString(this.uptime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

