/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.model;

import com.datadog.api.v1.client.model.UsageMetricCategory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Number of hourly recorded custom metrics for a given organization.")
@JsonPropertyOrder(value={"avg_metric_hour", "max_metric_hour", "metric_category", "metric_name"})
public class UsageTopAvgMetricsHour {
    public static final String JSON_PROPERTY_AVG_METRIC_HOUR = "avg_metric_hour";
    private Long avgMetricHour;
    public static final String JSON_PROPERTY_MAX_METRIC_HOUR = "max_metric_hour";
    private Long maxMetricHour;
    public static final String JSON_PROPERTY_METRIC_CATEGORY = "metric_category";
    private UsageMetricCategory metricCategory;
    public static final String JSON_PROPERTY_METRIC_NAME = "metric_name";
    private String metricName;

    public UsageTopAvgMetricsHour avgMetricHour(Long avgMetricHour) {
        this.avgMetricHour = avgMetricHour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Average number of timeseries per hour in which the metric occurs.")
    @JsonProperty(value="avg_metric_hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAvgMetricHour() {
        return this.avgMetricHour;
    }

    public void setAvgMetricHour(Long avgMetricHour) {
        this.avgMetricHour = avgMetricHour;
    }

    public UsageTopAvgMetricsHour maxMetricHour(Long maxMetricHour) {
        this.maxMetricHour = maxMetricHour;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Maximum number of timeseries per hour in which the metric occurs.")
    @JsonProperty(value="max_metric_hour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMaxMetricHour() {
        return this.maxMetricHour;
    }

    public void setMaxMetricHour(Long maxMetricHour) {
        this.maxMetricHour = maxMetricHour;
    }

    public UsageTopAvgMetricsHour metricCategory(UsageMetricCategory metricCategory) {
        this.metricCategory = metricCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="metric_category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UsageMetricCategory getMetricCategory() {
        return this.metricCategory;
    }

    public void setMetricCategory(UsageMetricCategory metricCategory) {
        this.metricCategory = metricCategory;
    }

    public UsageTopAvgMetricsHour metricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains the custom metric name.")
    @JsonProperty(value="metric_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageTopAvgMetricsHour usageTopAvgMetricsHour = (UsageTopAvgMetricsHour)o;
        return Objects.equals(this.avgMetricHour, usageTopAvgMetricsHour.avgMetricHour) && Objects.equals(this.maxMetricHour, usageTopAvgMetricsHour.maxMetricHour) && Objects.equals((Object)this.metricCategory, (Object)usageTopAvgMetricsHour.metricCategory) && Objects.equals(this.metricName, usageTopAvgMetricsHour.metricName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.avgMetricHour, this.maxMetricHour, this.metricCategory, this.metricName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageTopAvgMetricsHour {\n");
        sb.append("    avgMetricHour: ").append(this.toIndentedString(this.avgMetricHour)).append("\n");
        sb.append("    maxMetricHour: ").append(this.toIndentedString(this.maxMetricHour)).append("\n");
        sb.append("    metricCategory: ").append(this.toIndentedString((Object)this.metricCategory)).append("\n");
        sb.append("    metricName: ").append(this.toIndentedString(this.metricName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

