/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.IncidentRelatedObject;
import com.datadog.api.v2.client.model.IncidentServiceCreateRequest;
import com.datadog.api.v2.client.model.IncidentServiceResponse;
import com.datadog.api.v2.client.model.IncidentServiceUpdateRequest;
import com.datadog.api.v2.client.model.IncidentServicesResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class IncidentServicesApi {
    private ApiClient apiClient;

    public IncidentServicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IncidentServicesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<IncidentServiceResponse> createIncidentServiceWithHttpInfo(IncidentServiceCreateRequest body) throws ApiException {
        IncidentServiceCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createIncidentService");
        }
        String localVarPath = "/api/v2/services";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "createIncidentService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentServiceResponse> localVarReturnType = new GenericType<IncidentServiceResponse>(){};
        return this.apiClient.invokeAPI("IncidentServicesApi.createIncidentService", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIcreateIncidentServiceRequest createIncidentService() throws ApiException {
        String operationId = "createIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIcreateIncidentServiceRequest();
    }

    private ApiResponse<Void> deleteIncidentServiceWithHttpInfo(String serviceId) throws ApiException {
        Object localVarPostBody = null;
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling deleteIncidentService");
        }
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "deleteIncidentService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        return this.apiClient.invokeAPI("IncidentServicesApi.deleteIncidentService", localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null, false);
    }

    public APIdeleteIncidentServiceRequest deleteIncidentService(String serviceId) throws ApiException {
        String operationId = "deleteIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIdeleteIncidentServiceRequest(serviceId);
    }

    private ApiResponse<IncidentServiceResponse> getIncidentServiceWithHttpInfo(String serviceId, IncidentRelatedObject include) throws ApiException {
        Object localVarPostBody = null;
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling getIncidentService");
        }
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", (Object)include));
        localVarHeaderParams.put("DD-OPERATION-ID", "getIncidentService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentServiceResponse> localVarReturnType = new GenericType<IncidentServiceResponse>(){};
        return this.apiClient.invokeAPI("IncidentServicesApi.getIncidentService", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIgetIncidentServiceRequest getIncidentService(String serviceId) throws ApiException {
        String operationId = "getIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIgetIncidentServiceRequest(serviceId);
    }

    private ApiResponse<IncidentServicesResponse> listIncidentServicesWithHttpInfo(IncidentRelatedObject include, Long pageSize, Long pageOffset, String filter) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/services";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", (Object)include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarHeaderParams.put("DD-OPERATION-ID", "listIncidentServices");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentServicesResponse> localVarReturnType = new GenericType<IncidentServicesResponse>(){};
        return this.apiClient.invokeAPI("IncidentServicesApi.listIncidentServices", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistIncidentServicesRequest listIncidentServices() throws ApiException {
        String operationId = "listIncidentServices";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIlistIncidentServicesRequest();
    }

    private ApiResponse<IncidentServiceResponse> updateIncidentServiceWithHttpInfo(String serviceId, IncidentServiceUpdateRequest body) throws ApiException {
        IncidentServiceUpdateRequest localVarPostBody = body;
        if (serviceId == null) {
            throw new ApiException(400, "Missing the required parameter 'serviceId' when calling updateIncidentService");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateIncidentService");
        }
        String localVarPath = "/api/v2/services/{service_id}".replaceAll("\\{service_id\\}", this.apiClient.escapeString(serviceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "updateIncidentService");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<IncidentServiceResponse> localVarReturnType = new GenericType<IncidentServiceResponse>(){};
        return this.apiClient.invokeAPI("IncidentServicesApi.updateIncidentService", localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIupdateIncidentServiceRequest updateIncidentService(String serviceId) throws ApiException {
        String operationId = "updateIncidentService";
        if (!this.apiClient.isUnstableOperationEnabled(operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        return new APIupdateIncidentServiceRequest(serviceId);
    }

    public class APIupdateIncidentServiceRequest {
        private String serviceId;
        private IncidentServiceUpdateRequest body;

        private APIupdateIncidentServiceRequest(String serviceId) {
            this.serviceId = serviceId;
        }

        public APIupdateIncidentServiceRequest body(IncidentServiceUpdateRequest body) {
            this.body = body;
            return this;
        }

        public IncidentServiceResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentServiceResponse> executeWithHttpInfo() throws ApiException {
            return IncidentServicesApi.this.updateIncidentServiceWithHttpInfo(this.serviceId, this.body);
        }
    }

    public class APIlistIncidentServicesRequest {
        private IncidentRelatedObject include;
        private Long pageSize;
        private Long pageOffset;
        private String filter;

        private APIlistIncidentServicesRequest() {
        }

        public APIlistIncidentServicesRequest include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }

        public APIlistIncidentServicesRequest pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public APIlistIncidentServicesRequest pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }

        public APIlistIncidentServicesRequest filter(String filter) {
            this.filter = filter;
            return this;
        }

        public IncidentServicesResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentServicesResponse> executeWithHttpInfo() throws ApiException {
            return IncidentServicesApi.this.listIncidentServicesWithHttpInfo(this.include, this.pageSize, this.pageOffset, this.filter);
        }
    }

    public class APIgetIncidentServiceRequest {
        private String serviceId;
        private IncidentRelatedObject include;

        private APIgetIncidentServiceRequest(String serviceId) {
            this.serviceId = serviceId;
        }

        public APIgetIncidentServiceRequest include(IncidentRelatedObject include) {
            this.include = include;
            return this;
        }

        public IncidentServiceResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentServiceResponse> executeWithHttpInfo() throws ApiException {
            return IncidentServicesApi.this.getIncidentServiceWithHttpInfo(this.serviceId, this.include);
        }
    }

    public class APIdeleteIncidentServiceRequest {
        private String serviceId;

        private APIdeleteIncidentServiceRequest(String serviceId) {
            this.serviceId = serviceId;
        }

        public void execute() throws ApiException {
            this.executeWithHttpInfo().getData();
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return IncidentServicesApi.this.deleteIncidentServiceWithHttpInfo(this.serviceId);
        }
    }

    public class APIcreateIncidentServiceRequest {
        private IncidentServiceCreateRequest body;

        private APIcreateIncidentServiceRequest() {
        }

        public APIcreateIncidentServiceRequest body(IncidentServiceCreateRequest body) {
            this.body = body;
            return this;
        }

        public IncidentServiceResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<IncidentServiceResponse> executeWithHttpInfo() throws ApiException {
            return IncidentServicesApi.this.createIncidentServiceWithHttpInfo(this.body);
        }
    }
}

