/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.api;

import com.datadog.api.v2.client.ApiClient;
import com.datadog.api.v2.client.ApiException;
import com.datadog.api.v2.client.ApiResponse;
import com.datadog.api.v2.client.Configuration;
import com.datadog.api.v2.client.Pair;
import com.datadog.api.v2.client.model.ProcessSummariesResponse;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class ProcessesApi {
    private ApiClient apiClient;

    public ProcessesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProcessesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private ApiResponse<ProcessSummariesResponse> listProcessesWithHttpInfo(String search, String tags, Long from, Long to, Integer pageLimit, String pageCursor) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/processes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "search", search));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "from", from));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "to", to));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarHeaderParams.put("DD-OPERATION-ID", "listProcesses");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<ProcessSummariesResponse> localVarReturnType = new GenericType<ProcessSummariesResponse>(){};
        return this.apiClient.invokeAPI("ProcessesApi.listProcesses", localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public APIlistProcessesRequest listProcesses() throws ApiException {
        return new APIlistProcessesRequest();
    }

    public class APIlistProcessesRequest {
        private String search;
        private String tags;
        private Long from;
        private Long to;
        private Integer pageLimit;
        private String pageCursor;

        private APIlistProcessesRequest() {
        }

        public APIlistProcessesRequest search(String search) {
            this.search = search;
            return this;
        }

        public APIlistProcessesRequest tags(String tags) {
            this.tags = tags;
            return this;
        }

        public APIlistProcessesRequest from(Long from) {
            this.from = from;
            return this;
        }

        public APIlistProcessesRequest to(Long to) {
            this.to = to;
            return this;
        }

        public APIlistProcessesRequest pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public APIlistProcessesRequest pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ProcessSummariesResponse execute() throws ApiException {
            return this.executeWithHttpInfo().getData();
        }

        public ApiResponse<ProcessSummariesResponse> executeWithHttpInfo() throws ApiException {
            return ProcessesApi.this.listProcessesWithHttpInfo(this.search, this.tags, this.from, this.to, this.pageLimit, this.pageCursor);
        }
    }
}

