/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.IncidentServiceIncludedItems;
import com.datadog.api.v2.client.model.IncidentServiceResponseData;
import com.datadog.api.v2.client.model.IncidentServicesResponseMeta;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response with a list of incident service payloads.")
@JsonPropertyOrder(value={"data", "included", "meta"})
public class IncidentServicesResponse {
    public static final String JSON_PROPERTY_DATA = "data";
    private List<IncidentServiceResponseData> data = new ArrayList<IncidentServiceResponseData>();
    public static final String JSON_PROPERTY_INCLUDED = "included";
    private List<IncidentServiceIncludedItems> included = null;
    public static final String JSON_PROPERTY_META = "meta";
    private IncidentServicesResponseMeta meta;

    public IncidentServicesResponse data(List<IncidentServiceResponseData> data) {
        this.data = data;
        return this;
    }

    public IncidentServicesResponse addDataItem(IncidentServiceResponseData dataItem) {
        this.data.add(dataItem);
        return this;
    }

    @ApiModelProperty(example="[{\"id\":\"00000000-0000-0000-0000-000000000000\",\"type\":\"services\"}]", required=true, value="An array of incident services.")
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IncidentServiceResponseData> getData() {
        return this.data;
    }

    public void setData(List<IncidentServiceResponseData> data) {
        this.data = data;
    }

    @Nullable
    @ApiModelProperty(value="Included related resources which the user requested.")
    @JsonProperty(value="included")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<IncidentServiceIncludedItems> getIncluded() {
        return this.included;
    }

    public IncidentServicesResponse meta(IncidentServicesResponseMeta meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IncidentServicesResponseMeta getMeta() {
        return this.meta;
    }

    public void setMeta(IncidentServicesResponseMeta meta) {
        this.meta = meta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentServicesResponse incidentServicesResponse = (IncidentServicesResponse)o;
        return Objects.equals(this.data, incidentServicesResponse.data) && Objects.equals(this.included, incidentServicesResponse.included) && Objects.equals(this.meta, incidentServicesResponse.meta);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.included, this.meta);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentServicesResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

