/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.LogsArchiveDestinationGCSType;
import com.datadog.api.v2.client.model.LogsArchiveIntegrationGCS;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The GCS archive destination.")
@JsonPropertyOrder(value={"bucket", "integration", "path", "type"})
public class LogsArchiveDestinationGCS {
    public static final String JSON_PROPERTY_BUCKET = "bucket";
    private String bucket;
    public static final String JSON_PROPERTY_INTEGRATION = "integration";
    private LogsArchiveIntegrationGCS integration;
    public static final String JSON_PROPERTY_PATH = "path";
    private String path;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsArchiveDestinationGCSType type = LogsArchiveDestinationGCSType.GCS;

    public LogsArchiveDestinationGCS bucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    @ApiModelProperty(example="bucket-name", required=true, value="The bucket where the archive will be stored.")
    @JsonProperty(value="bucket")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public LogsArchiveDestinationGCS integration(LogsArchiveIntegrationGCS integration) {
        this.integration = integration;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="integration")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsArchiveIntegrationGCS getIntegration() {
        return this.integration;
    }

    public void setIntegration(LogsArchiveIntegrationGCS integration) {
        this.integration = integration;
    }

    public LogsArchiveDestinationGCS path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The archive path.")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public LogsArchiveDestinationGCS type(LogsArchiveDestinationGCSType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsArchiveDestinationGCSType getType() {
        return this.type;
    }

    public void setType(LogsArchiveDestinationGCSType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsArchiveDestinationGCS logsArchiveDestinationGCS = (LogsArchiveDestinationGCS)o;
        return Objects.equals(this.bucket, logsArchiveDestinationGCS.bucket) && Objects.equals(this.integration, logsArchiveDestinationGCS.integration) && Objects.equals(this.path, logsArchiveDestinationGCS.path) && Objects.equals((Object)this.type, (Object)logsArchiveDestinationGCS.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bucket, this.integration, this.path, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsArchiveDestinationGCS {\n");
        sb.append("    bucket: ").append(this.toIndentedString(this.bucket)).append("\n");
        sb.append("    integration: ").append(this.toIndentedString(this.integration)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

