/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.datadog.api.v2.client.model.LogsAggregateResponseStatus;
import com.datadog.api.v2.client.model.LogsResponseMetadataPage;
import com.datadog.api.v2.client.model.LogsWarning;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The metadata associated with a request")
@JsonPropertyOrder(value={"elapsed", "page", "request_id", "status", "warnings"})
public class LogsResponseMetadata {
    public static final String JSON_PROPERTY_ELAPSED = "elapsed";
    private Long elapsed;
    public static final String JSON_PROPERTY_PAGE = "page";
    private LogsResponseMetadataPage page;
    public static final String JSON_PROPERTY_REQUEST_ID = "request_id";
    private String requestId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private LogsAggregateResponseStatus status;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private List<LogsWarning> warnings = null;

    public LogsResponseMetadata elapsed(Long elapsed) {
        this.elapsed = elapsed;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="132", value="The time elapsed in milliseconds")
    @JsonProperty(value="elapsed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(Long elapsed) {
        this.elapsed = elapsed;
    }

    public LogsResponseMetadata page(LogsResponseMetadataPage page) {
        this.page = page;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsResponseMetadataPage getPage() {
        return this.page;
    }

    public void setPage(LogsResponseMetadataPage page) {
        this.page = page;
    }

    public LogsResponseMetadata requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="MWlFUjVaWGZTTTZPYzM0VXp1OXU2d3xLSVpEMjZKQ0VKUTI0dEYtM3RSOFVR", value="The identifier of the request")
    @JsonProperty(value="request_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public LogsResponseMetadata status(LogsAggregateResponseStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsAggregateResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(LogsAggregateResponseStatus status) {
        this.status = status;
    }

    public LogsResponseMetadata warnings(List<LogsWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public LogsResponseMetadata addWarningsItem(LogsWarning warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<LogsWarning>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of warnings (non fatal errors) encountered, partial results might be returned if warnings are present in the response.")
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<LogsWarning> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsResponseMetadata logsResponseMetadata = (LogsResponseMetadata)o;
        return Objects.equals(this.elapsed, logsResponseMetadata.elapsed) && Objects.equals(this.page, logsResponseMetadata.page) && Objects.equals(this.requestId, logsResponseMetadata.requestId) && Objects.equals((Object)this.status, (Object)logsResponseMetadata.status) && Objects.equals(this.warnings, logsResponseMetadata.warnings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.elapsed, this.page, this.requestId, this.status, this.warnings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsResponseMetadata {\n");
        sb.append("    elapsed: ").append(this.toIndentedString(this.elapsed)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

