/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v2.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Attributes of a partial application key.")
@JsonPropertyOrder(value={"created_at", "last4", "name"})
public class PartialApplicationKeyAttributes {
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private String createdAt;
    public static final String JSON_PROPERTY_LAST4 = "last4";
    private String last4;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    @Nullable
    @ApiModelProperty(example="2020-11-23T10:00:00.000Z", value="Creation date of the application key.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @ApiModelProperty(example="abcd", value="The last four characters of the application key.")
    @JsonProperty(value="last4")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLast4() {
        return this.last4;
    }

    public PartialApplicationKeyAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Application Key for submitting metrics", value="Name of the application key.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialApplicationKeyAttributes partialApplicationKeyAttributes = (PartialApplicationKeyAttributes)o;
        return Objects.equals(this.createdAt, partialApplicationKeyAttributes.createdAt) && Objects.equals(this.last4, partialApplicationKeyAttributes.last4) && Objects.equals(this.name, partialApplicationKeyAttributes.name);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.last4, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartialApplicationKeyAttributes {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    last4: ").append(this.toIndentedString(this.last4)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

