/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.v1.client.api;

import com.datadog.api.v1.client.ApiClient;
import com.datadog.api.v1.client.ApiException;
import com.datadog.api.v1.client.ApiResponse;
import com.datadog.api.v1.client.Configuration;
import com.datadog.api.v1.client.Pair;
import com.datadog.api.v1.client.model.ContentEncoding;
import com.datadog.api.v1.client.model.HTTPLogItem;
import com.datadog.api.v1.client.model.LogsListRequest;
import com.datadog.api.v1.client.model.LogsListResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.GenericType;

public class LogsApi {
    private ApiClient apiClient;

    public LogsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public LogsListResponse listLogs(LogsListRequest body) throws ApiException {
        return this.listLogsWithHttpInfo(body).getData();
    }

    public ApiResponse<LogsListResponse> listLogsWithHttpInfo(LogsListRequest body) throws ApiException {
        LogsListRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling listLogs");
        }
        String localVarPath = "/api/v1/logs-queries/list";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.put("DD-OPERATION-ID", "listLogs");
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth", "appKeyAuth"};
        GenericType<LogsListResponse> localVarReturnType = new GenericType<LogsListResponse>(){};
        return this.apiClient.invokeAPI("LogsApi.listLogs", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public Object submitLog(List<HTTPLogItem> body) throws ApiException {
        return this.submitLogWithHttpInfo(body, new SubmitLogOptionalParameters()).getData();
    }

    public Object submitLog(List<HTTPLogItem> body, SubmitLogOptionalParameters parameters) throws ApiException {
        return this.submitLogWithHttpInfo(body, parameters).getData();
    }

    public ApiResponse<Object> submitLogWithHttpInfo(List<HTTPLogItem> body, SubmitLogOptionalParameters parameters) throws ApiException {
        List<HTTPLogItem> localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling submitLog");
        }
        ContentEncoding contentEncoding = parameters.contentEncoding;
        String ddtags = parameters.ddtags;
        String localVarPath = "/v1/input";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ddtags", ddtags));
        localVarHeaderParams.put("DD-OPERATION-ID", "submitLog");
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString((Object)contentEncoding));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json", "application/logplex-1", "text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiKeyAuth"};
        GenericType<Object> localVarReturnType = new GenericType<Object>(){};
        return this.apiClient.invokeAPI("LogsApi.submitLog", localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType, false);
    }

    public static class SubmitLogOptionalParameters {
        private ContentEncoding contentEncoding;
        private String ddtags;

        public SubmitLogOptionalParameters contentEncoding(ContentEncoding contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public SubmitLogOptionalParameters ddtags(String ddtags) {
            this.ddtags = ddtags;
            return this;
        }
    }
}

